/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.dialect;

import java.util.function.Function;
import org.seasar.doma.internal.jdbc.dialect.AbstractTransformer;
import org.seasar.doma.internal.jdbc.sql.SimpleSqlNodeVisitor;
import org.seasar.doma.internal.jdbc.sql.node.AnonymousNode;
import org.seasar.doma.internal.jdbc.sql.node.AppendableSqlNode;
import org.seasar.doma.internal.jdbc.sql.node.ElseNode;
import org.seasar.doma.internal.jdbc.sql.node.ElseifNode;
import org.seasar.doma.internal.jdbc.sql.node.EndNode;
import org.seasar.doma.internal.jdbc.sql.node.ForBlockNode;
import org.seasar.doma.internal.jdbc.sql.node.ForNode;
import org.seasar.doma.internal.jdbc.sql.node.FragmentNode;
import org.seasar.doma.internal.jdbc.sql.node.FromClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.IfBlockNode;
import org.seasar.doma.internal.jdbc.sql.node.IfNode;
import org.seasar.doma.internal.jdbc.sql.node.OrderByClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.SelectClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.SelectStatementNode;
import org.seasar.doma.internal.jdbc.sql.node.WhereClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.WordNode;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class StandardPagingTransformer
extends AbstractTransformer {
    private final AliasReplacer replacer = new AliasReplacer();
    protected final long offset;
    protected final long limit;
    protected boolean processed;

    public StandardPagingTransformer(long offset, long limit) {
        AssertionUtil.assertTrue(offset >= 0L || limit >= 0L, new Object[0]);
        this.offset = offset;
        this.limit = limit;
    }

    public SqlNode transform(SqlNode sqlNode) {
        AnonymousNode result = new AnonymousNode();
        for (SqlNode child : sqlNode.getChildren()) {
            result.appendNode(child.accept(this, null));
        }
        return result;
    }

    @Override
    public SqlNode visitSelectStatementNode(SelectStatementNode node, Void p) {
        if (this.processed) {
            return node;
        }
        this.processed = true;
        OrderByClauseNode originalOrderBy = node.getOrderByClauseNode();
        if (originalOrderBy == null) {
            throw new JdbcException((MessageResource)Message.DOMA2201, new Object[0]);
        }
        SelectStatementNode subStatement = new SelectStatementNode();
        subStatement.setSelectClauseNode(node.getSelectClauseNode());
        subStatement.setFromClauseNode(node.getFromClauseNode());
        subStatement.setWhereClauseNode(node.getWhereClauseNode());
        subStatement.setGroupByClauseNode(node.getGroupByClauseNode());
        subStatement.setHavingClauseNode(node.getHavingClauseNode());
        OrderByClauseNode orderBy = new OrderByClauseNode(originalOrderBy.getWordNode());
        for (SqlNode child : originalOrderBy.getChildren()) {
            SqlNode newChild = child.accept(this.replacer, null);
            orderBy.appendNode(newChild);
        }
        SelectClauseNode select = new SelectClauseNode("select");
        select.appendNode(new FragmentNode(" * "));
        FromClauseNode from = new FromClauseNode("from");
        from.appendNode(new FragmentNode(" ( select temp_.*, row_number() over( "));
        from.appendNode(orderBy);
        from.appendNode(new FragmentNode(" ) as doma_rownumber_ from ( "));
        from.appendNode(subStatement);
        from.appendNode(new FragmentNode(") as temp_ ) as temp2_ "));
        WhereClauseNode where = new WhereClauseNode("where");
        where.appendNode(new FragmentNode(" "));
        if (this.offset >= 0L) {
            where.appendNode(new FragmentNode("doma_rownumber_ > "));
            where.appendNode(new FragmentNode(String.valueOf(this.offset)));
        }
        if (this.limit > 0L) {
            if (this.offset >= 0L) {
                where.appendNode(new FragmentNode(" and "));
            }
            long bias = this.offset < 0L ? 0L : this.offset;
            where.appendNode(new FragmentNode("doma_rownumber_ <= "));
            where.appendNode(new FragmentNode(String.valueOf(bias + this.limit)));
        }
        SelectStatementNode result = new SelectStatementNode();
        result.setSelectClauseNode(select);
        result.setFromClauseNode(from);
        result.setWhereClauseNode(where);
        result.setForUpdateClauseNode(node.getForUpdateClauseNode());
        result.setOptionClauseNode(node.getOptionClauseNode());
        return result;
    }

    protected static class AliasReplacer
    extends SimpleSqlNodeVisitor<SqlNode, Void> {
        protected AliasReplacer() {
        }

        @Override
        public SqlNode visitWordNode(WordNode node, Void aVoid) {
            String word = node.getWord();
            String[] names = word.split("\\.");
            if (names.length == 2) {
                return new WordNode("temp_." + names[1]);
            }
            return node;
        }

        @Override
        public SqlNode visitIfBlockNode(IfBlockNode node, Void aVoid) {
            EndNode originalEndNode;
            IfBlockNode ifBlockNode = new IfBlockNode();
            IfNode originalIfNode = node.getIfNode();
            IfNode ifNode = this.buildNode(originalIfNode, o -> new IfNode(o.getLocation(), o.getExpression(), o.getText()));
            ifBlockNode.setIfNode(ifNode);
            for (ElseifNode originalElseifNode : node.getElseifNodes()) {
                ElseifNode elseifNode = this.buildNode(originalElseifNode, o -> new ElseifNode(o.getLocation(), o.getExpression(), o.getText()));
                ifBlockNode.addElseifNode(elseifNode);
            }
            ElseNode originalElseNode = node.getElseNode();
            if (originalElseNode != null) {
                ElseNode elseNode = this.buildNode(originalElseNode, o -> new ElseNode(o.getText()));
                ifBlockNode.setElseNode(elseNode);
            }
            if ((originalEndNode = node.getEndNode()) != null) {
                EndNode endNode = this.buildNode(originalEndNode, o -> new EndNode(o.getText()));
                ifBlockNode.setEndNode(endNode);
            }
            return ifBlockNode;
        }

        @Override
        public SqlNode visitForBlockNode(ForBlockNode node, Void aVoid) {
            ForBlockNode forBlockNode = new ForBlockNode();
            ForNode originalForNode = node.getForNode();
            ForNode forNode = this.buildNode(originalForNode, o -> new ForNode(o.getLocation(), o.getIdentifier(), o.getExpression(), o.getText()));
            forBlockNode.setForNode(forNode);
            EndNode originalEndNode = node.getEndNode();
            if (originalEndNode != null) {
                EndNode endNode = this.buildNode(originalEndNode, o -> new EndNode(o.getText()));
                forBlockNode.setEndNode(endNode);
            }
            return forBlockNode;
        }

        private <NODE extends AppendableSqlNode> NODE buildNode(NODE originalNode, Function<NODE, NODE> factory) {
            AppendableSqlNode newNode = (AppendableSqlNode)factory.apply(originalNode);
            for (SqlNode child : originalNode.getChildren()) {
                SqlNode newChild = child.accept(this, null);
                newNode.appendNode(newChild);
            }
            return (NODE)newNode;
        }

        @Override
        protected SqlNode defaultAction(SqlNode node, Void p) {
            return node;
        }
    }
}

