/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.entity;

import java.lang.reflect.Field;
import java.util.LinkedList;
import org.seasar.doma.internal.WrapException;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.internal.util.FieldUtil;
import org.seasar.doma.jdbc.entity.EntityPropertyAccessException;
import org.seasar.doma.jdbc.entity.EntityPropertyNotFoundException;

public class PropertyField<ENTITY> {
    protected final String path;
    protected final Class<ENTITY> entityClass;
    protected final LinkedList<Field> fields = new LinkedList();

    public PropertyField(String path, Class<ENTITY> entityClass) {
        AssertionUtil.assertNotNull((Object)path, entityClass);
        this.path = path;
        this.entityClass = entityClass;
        String[] segments = path.split("\\.");
        Class<Object> clazz = entityClass;
        for (String segment : segments) {
            Field field = this.getField(clazz, segment);
            this.fields.add(field);
            clazz = field.getType();
        }
        AssertionUtil.assertTrue(this.fields.size() > 0, new Object[0]);
    }

    private Field getField(Class<?> clazz, String name) {
        Field field = this.findField(clazz, name);
        if (field == null) {
            throw new EntityPropertyNotFoundException(clazz.getName(), name);
        }
        if (!FieldUtil.isPublic(field)) {
            try {
                FieldUtil.setAccessible(field, true);
            }
            catch (WrapException wrapException) {
                throw new EntityPropertyAccessException(wrapException.getCause(), clazz.getName(), name);
            }
        }
        return field;
    }

    private Field findField(Class<?> clazz, String name) {
        for (Class<?> cl = clazz; cl != Object.class; cl = cl.getSuperclass()) {
            try {
                return cl.getDeclaredField(name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    public Object getValue(ENTITY entity) {
        AssertionUtil.assertNotNull(entity);
        Object value = entity;
        for (Field field : this.fields) {
            if (value == null) break;
            value = this.getFieldValue(field, value);
        }
        return value;
    }

    private Object getFieldValue(Field field, Object target) {
        try {
            return FieldUtil.get(field, target);
        }
        catch (WrapException wrapException) {
            throw new EntityPropertyAccessException(wrapException.getCause(), this.entityClass.getName(), this.path);
        }
    }

    public void setValue(ENTITY entity, Object value) {
        AssertionUtil.assertNotNull(entity);
        if (this.fields.size() > 1) {
            throw new UnsupportedOperationException();
        }
        this.setFieldValue(this.fields.getFirst(), entity, value);
    }

    private void setFieldValue(Field field, ENTITY entity, Object value) {
        try {
            FieldUtil.set(field, entity, value);
        }
        catch (WrapException wrapException) {
            throw new EntityPropertyAccessException(wrapException.getCause(), this.entityClass.getName(), this.path);
        }
    }

    public boolean isPrimitive() {
        Field field = this.fields.getLast();
        return field.getType().isPrimitive();
    }
}

