/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.scalar;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.function.Supplier;
import org.seasar.doma.Domain;
import org.seasar.doma.internal.jdbc.scalar.BasicScalar;
import org.seasar.doma.internal.jdbc.scalar.OptionalBasicScalar;
import org.seasar.doma.internal.jdbc.scalar.Scalar;
import org.seasar.doma.internal.jdbc.scalar.ScalarException;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.ClassHelper;
import org.seasar.doma.jdbc.domain.DomainType;
import org.seasar.doma.jdbc.domain.DomainTypeFactory;
import org.seasar.doma.message.Message;
import org.seasar.doma.wrapper.ArrayWrapper;
import org.seasar.doma.wrapper.BigDecimalWrapper;
import org.seasar.doma.wrapper.BigIntegerWrapper;
import org.seasar.doma.wrapper.BlobWrapper;
import org.seasar.doma.wrapper.BooleanWrapper;
import org.seasar.doma.wrapper.ByteWrapper;
import org.seasar.doma.wrapper.BytesWrapper;
import org.seasar.doma.wrapper.ClobWrapper;
import org.seasar.doma.wrapper.DateWrapper;
import org.seasar.doma.wrapper.DoubleWrapper;
import org.seasar.doma.wrapper.EnumWrapper;
import org.seasar.doma.wrapper.FloatWrapper;
import org.seasar.doma.wrapper.IntegerWrapper;
import org.seasar.doma.wrapper.LocalDateTimeWrapper;
import org.seasar.doma.wrapper.LocalDateWrapper;
import org.seasar.doma.wrapper.LocalTimeWrapper;
import org.seasar.doma.wrapper.LongWrapper;
import org.seasar.doma.wrapper.NClobWrapper;
import org.seasar.doma.wrapper.ObjectWrapper;
import org.seasar.doma.wrapper.PrimitiveBooleanWrapper;
import org.seasar.doma.wrapper.PrimitiveByteWrapper;
import org.seasar.doma.wrapper.PrimitiveDoubleWrapper;
import org.seasar.doma.wrapper.PrimitiveFloatWrapper;
import org.seasar.doma.wrapper.PrimitiveIntWrapper;
import org.seasar.doma.wrapper.PrimitiveLongWrapper;
import org.seasar.doma.wrapper.PrimitiveShortWrapper;
import org.seasar.doma.wrapper.SQLXMLWrapper;
import org.seasar.doma.wrapper.ShortWrapper;
import org.seasar.doma.wrapper.StringWrapper;
import org.seasar.doma.wrapper.TimeWrapper;
import org.seasar.doma.wrapper.TimestampWrapper;
import org.seasar.doma.wrapper.UtilDateWrapper;
import org.seasar.doma.wrapper.Wrapper;

public final class Scalars {
    public static Supplier<Scalar<?, ?>> wrap(Object value, Class<?> valueClass, boolean optional, ClassHelper classHelper) {
        AssertionUtil.assertNotNull(valueClass, (Object)classHelper);
        if (Scalar.class.isAssignableFrom(valueClass)) {
            return () -> (Scalar)value;
        }
        Supplier<Scalar<?, ?>> result = Scalars.wrapBasicObject(value, valueClass, optional);
        if (result == null && (result = Scalars.wrapDomainObject(value, valueClass, optional, classHelper)) == null && (result = Scalars.wrapEnumObject(value, valueClass, optional)) == null) {
            throw new ScalarException(Message.DOMA1007, valueClass.getName());
        }
        return result;
    }

    protected static Supplier<Scalar<?, ?>> wrapBasicObject(Object value, Class<?> valueClass, boolean optional) {
        AssertionUtil.assertNotNull(valueClass);
        if (valueClass == String.class) {
            Supplier supplier = () -> new StringWrapper((String)value);
            return Scalars.createBasicScalarSupplier(supplier, optional);
        }
        if (valueClass == Boolean.TYPE) {
            Supplier supplier = () -> value == null ? new PrimitiveBooleanWrapper() : new PrimitiveBooleanWrapper((boolean)((Boolean)value));
            return Scalars.createBasicScalarSupplier(supplier, optional);
        }
        if (valueClass == Byte.TYPE) {
            Supplier supplier = () -> value == null ? new PrimitiveByteWrapper() : new PrimitiveByteWrapper((byte)((Byte)value));
            return Scalars.createBasicScalarSupplier(supplier, optional);
        }
        if (valueClass == Double.TYPE) {
            Supplier supplier = () -> value == null ? new PrimitiveDoubleWrapper() : new PrimitiveDoubleWrapper((double)((Double)value));
            return Scalars.createBasicScalarSupplier(supplier, optional);
        }
        if (valueClass == Float.TYPE) {
            Supplier supplier = () -> value == null ? new PrimitiveFloatWrapper() : new PrimitiveFloatWrapper(((Float)value).floatValue());
            return Scalars.createBasicScalarSupplier(supplier, optional);
        }
        if (valueClass == Integer.TYPE) {
            Supplier supplier = () -> value == null ? new PrimitiveIntWrapper() : new PrimitiveIntWrapper((int)((Integer)value));
            return Scalars.createBasicScalarSupplier(supplier, optional);
        }
        if (valueClass == Long.TYPE) {
            Supplier supplier = () -> value == null ? new PrimitiveLongWrapper() : new PrimitiveLongWrapper((long)((Long)value));
            return Scalars.createBasicScalarSupplier(supplier, optional);
        }
        if (valueClass == Short.TYPE) {
            Supplier supplier = () -> value == null ? new PrimitiveShortWrapper() : new PrimitiveShortWrapper((short)((Short)value));
            return Scalars.createBasicScalarSupplier(supplier, optional);
        }
        if (valueClass == Integer.class) {
            Supplier supplier = () -> new IntegerWrapper((Integer)value);
            return Scalars.createBasicScalarSupplier(supplier, optional);
        }
        if (valueClass == Long.class) {
            Supplier supplier = () -> new LongWrapper((Long)value);
            return Scalars.createBasicScalarSupplier(supplier, optional);
        }
        if (valueClass == BigDecimal.class) {
            Supplier supplier = () -> new BigDecimalWrapper((BigDecimal)value);
            return Scalars.createBasicScalarSupplier(supplier, optional);
        }
        if (valueClass == java.util.Date.class) {
            Supplier supplier = () -> new UtilDateWrapper((java.util.Date)value);
            return Scalars.createBasicScalarSupplier(supplier, optional);
        }
        if (valueClass == LocalDate.class) {
            Supplier supplier = () -> new LocalDateWrapper((LocalDate)value);
            return Scalars.createBasicScalarSupplier(supplier, optional);
        }
        if (valueClass == LocalTime.class) {
            Supplier supplier = () -> new LocalTimeWrapper((LocalTime)value);
            return Scalars.createBasicScalarSupplier(supplier, optional);
        }
        if (valueClass == LocalDateTime.class) {
            Supplier supplier = () -> new LocalDateTimeWrapper((LocalDateTime)value);
            return Scalars.createBasicScalarSupplier(supplier, optional);
        }
        if (valueClass == Date.class) {
            Supplier supplier = () -> new DateWrapper((Date)value);
            return Scalars.createBasicScalarSupplier(supplier, optional);
        }
        if (valueClass == Timestamp.class) {
            Supplier supplier = () -> new TimestampWrapper((Timestamp)value);
            return Scalars.createBasicScalarSupplier(supplier, optional);
        }
        if (valueClass == Time.class) {
            Supplier supplier = () -> new TimeWrapper((Time)value);
            return Scalars.createBasicScalarSupplier(supplier, optional);
        }
        if (valueClass == Boolean.class) {
            Supplier supplier = () -> new BooleanWrapper((Boolean)value);
            return Scalars.createBasicScalarSupplier(supplier, optional);
        }
        if (valueClass == Array.class) {
            Supplier supplier = () -> new ArrayWrapper((Array)value);
            return Scalars.createBasicScalarSupplier(supplier, optional);
        }
        if (valueClass == BigInteger.class) {
            Supplier supplier = () -> new BigIntegerWrapper((BigInteger)value);
            return Scalars.createBasicScalarSupplier(supplier, optional);
        }
        if (valueClass == Blob.class) {
            Supplier supplier = () -> new BlobWrapper((Blob)value);
            return Scalars.createBasicScalarSupplier(supplier, optional);
        }
        if (valueClass == byte[].class) {
            Supplier supplier = () -> new BytesWrapper((byte[])value);
            return Scalars.createBasicScalarSupplier(supplier, optional);
        }
        if (valueClass == Byte.class) {
            Supplier supplier = () -> new ByteWrapper((Byte)value);
            return Scalars.createBasicScalarSupplier(supplier, optional);
        }
        if (valueClass == Clob.class) {
            Supplier supplier = () -> new ClobWrapper((Clob)value);
            return Scalars.createBasicScalarSupplier(supplier, optional);
        }
        if (valueClass == Double.class) {
            Supplier supplier = () -> new DoubleWrapper((Double)value);
            return Scalars.createBasicScalarSupplier(supplier, optional);
        }
        if (valueClass == Float.class) {
            Supplier supplier = () -> new FloatWrapper((Float)value);
            return Scalars.createBasicScalarSupplier(supplier, optional);
        }
        if (valueClass == NClob.class) {
            Supplier supplier = () -> new NClobWrapper((NClob)value);
            return Scalars.createBasicScalarSupplier(supplier, optional);
        }
        if (valueClass == Short.class) {
            Supplier supplier = () -> new ShortWrapper((Short)value);
            return Scalars.createBasicScalarSupplier(supplier, optional);
        }
        if (valueClass == SQLXML.class) {
            Supplier supplier = () -> new SQLXMLWrapper((SQLXML)value);
            return Scalars.createBasicScalarSupplier(supplier, optional);
        }
        if (valueClass == Object.class) {
            Supplier supplier = () -> new ObjectWrapper(value);
            return Scalars.createBasicScalarSupplier(supplier, optional);
        }
        return null;
    }

    protected static <BASIC> Supplier<Scalar<?, ?>> createBasicScalarSupplier(Supplier<Wrapper<BASIC>> wrapperSupplier, boolean optional) {
        if (optional) {
            return () -> new OptionalBasicScalar(wrapperSupplier);
        }
        return () -> new BasicScalar(wrapperSupplier);
    }

    protected static Supplier<Scalar<?, ?>> wrapEnumObject(Object value, Class<?> valueClass, boolean optional) {
        AssertionUtil.assertNotNull(valueClass);
        if (valueClass.isEnum() || Enum.class.isAssignableFrom(valueClass)) {
            Supplier<EnumWrapper> supplier = () -> new EnumWrapper<Enum>(valueClass, (Enum)value);
            if (optional) {
                return () -> new OptionalBasicScalar(supplier);
            }
            return () -> new BasicScalar(supplier);
        }
        return null;
    }

    protected static <BASIC, DOMAIN> Supplier<Scalar<?, ?>> wrapDomainObject(Object value, Class<DOMAIN> valueClass, boolean optional, ClassHelper classHelper) {
        DomainType domainType = valueClass.isAnnotationPresent(Domain.class) ? DomainTypeFactory.getDomainType(valueClass, classHelper) : DomainTypeFactory.getExternalDomainType(valueClass, classHelper);
        if (domainType == null) {
            return null;
        }
        Object domain = valueClass.cast(value);
        if (optional) {
            return () -> domainType.createOptionalScalar(domain);
        }
        return () -> domainType.createScalar(domain);
    }
}

