/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.sql;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import org.seasar.doma.internal.jdbc.sql.ConvertToLogFormatFunction;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.CallableSql;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.InParameter;
import org.seasar.doma.jdbc.ListParameter;
import org.seasar.doma.jdbc.OutParameter;
import org.seasar.doma.jdbc.ResultListParameter;
import org.seasar.doma.jdbc.ResultParameter;
import org.seasar.doma.jdbc.SingleResultParameter;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.SqlLogFormattingFunction;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.jdbc.SqlParameter;
import org.seasar.doma.jdbc.SqlParameterVisitor;
import org.seasar.doma.wrapper.Wrapper;

public class CallableSqlBuilder
implements SqlParameterVisitor<Void, Context, RuntimeException> {
    protected final Config config;
    protected final SqlKind kind;
    protected final ResultParameter<?> resultParameter;
    protected final List<SqlParameter> parameters;
    protected final String moduleName;
    protected final SqlLogType sqlLogType;
    protected final SqlLogFormattingFunction formattingFunction;
    protected boolean began;

    public CallableSqlBuilder(Config config, SqlKind kind, String moduleName, List<SqlParameter> parameters, SqlLogType sqlLogType) {
        this(config, kind, moduleName, parameters, sqlLogType, null);
    }

    public CallableSqlBuilder(Config config, SqlKind kind, String moduleName, List<SqlParameter> parameters, SqlLogType sqlLogType, ResultParameter<?> resultParameter) {
        AssertionUtil.assertNotNull((Object)config, (Object)kind, parameters, (Object)moduleName, (Object)sqlLogType);
        this.config = config;
        this.kind = kind;
        this.resultParameter = resultParameter;
        this.parameters = parameters;
        this.moduleName = moduleName;
        this.sqlLogType = sqlLogType;
        this.formattingFunction = new ConvertToLogFormatFunction();
    }

    public CallableSql build(Function<String, String> commenter) {
        AssertionUtil.assertNotNull(commenter);
        Context context = new Context();
        context.append("{");
        if (this.resultParameter != null) {
            this.resultParameter.accept(this, context);
            context.append("= ");
        }
        context.append("call ");
        context.append(this.moduleName);
        context.append("(");
        for (SqlParameter parameter : this.parameters) {
            parameter.accept(this, context);
        }
        context.cutBackIfNecessary();
        context.append(")}");
        LinkedList<SqlParameter> allParameters = new LinkedList<SqlParameter>(this.parameters);
        if (this.resultParameter != null) {
            allParameters.addFirst(this.resultParameter);
        }
        return new CallableSql(this.kind, context.getSqlBuf(), context.getFormattedSqlBuf(), allParameters, this.sqlLogType, commenter);
    }

    @Override
    public <BASIC> Void visitInParameter(InParameter<BASIC> parameter, Context p) throws RuntimeException {
        Wrapper wrapper = parameter.getWrapper();
        p.appendRawSql("?, ");
        p.appendFormattedSql(wrapper.accept(this.config.getDialect().getSqlLogFormattingVisitor(), this.formattingFunction, null));
        p.appendFormattedSql(", ");
        p.addParameter(parameter);
        return null;
    }

    @Override
    public <BASIC> Void visitOutParameter(OutParameter<BASIC> parameter, Context p) throws RuntimeException {
        p.appendRawSql("?, ");
        p.appendFormattedSql("?, ");
        p.addParameter(parameter);
        return null;
    }

    @Override
    public <BASIC, INOUT extends InParameter<BASIC> & OutParameter<BASIC>> Void visitInOutParameter(INOUT parameter, Context p) throws RuntimeException {
        this.visitInParameter((InParameter<BASIC>)parameter, p);
        return null;
    }

    @Override
    public <ELEMENT> Void visitListParameter(ListParameter<ELEMENT> parameter, Context p) throws RuntimeException {
        if (this.config.getDialect().supportsResultSetReturningAsOutParameter()) {
            p.appendRawSql("?, ");
            p.appendFormattedSql("?, ");
            p.addParameter(parameter);
        }
        return null;
    }

    @Override
    public <BASIC, RESULT> Void visitSingleResultParameter(SingleResultParameter<BASIC, RESULT> parameter, Context p) throws RuntimeException {
        p.appendRawSql("? ");
        p.appendFormattedSql("? ");
        return null;
    }

    @Override
    public <ELEMENT> Void visitResultListParameter(ResultListParameter<ELEMENT> parameter, Context p) throws RuntimeException {
        p.appendRawSql("? ");
        p.appendFormattedSql("? ");
        return null;
    }

    protected static class Context {
        private final StringBuilder rawSqlBuf = new StringBuilder(200);
        private final StringBuilder formattedSqlBuf = new StringBuilder(200);
        private final List<SqlParameter> contextParameters = new ArrayList<SqlParameter>();

        protected Context() {
        }

        protected void append(CharSequence sql) {
            this.appendRawSql(sql);
            this.appendFormattedSql(sql);
        }

        protected void cutBackIfNecessary() {
            if (!this.contextParameters.isEmpty()) {
                this.rawSqlBuf.setLength(this.rawSqlBuf.length() - 2);
                this.formattedSqlBuf.setLength(this.formattedSqlBuf.length() - 2);
            }
        }

        protected void appendRawSql(CharSequence sql) {
            this.rawSqlBuf.append(sql);
        }

        protected void appendFormattedSql(CharSequence sql) {
            this.formattedSqlBuf.append(sql);
        }

        protected CharSequence getSqlBuf() {
            return this.rawSqlBuf;
        }

        protected CharSequence getFormattedSqlBuf() {
            return this.formattedSqlBuf;
        }

        protected void addParameter(SqlParameter parameter) {
            this.contextParameters.add(parameter);
        }

        public String toString() {
            return this.rawSqlBuf.toString();
        }
    }
}

