/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.sql.node;

import java.util.HashMap;
import java.util.Map;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.jdbc.sql.node.AbstractSqlNode;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.JdbcUnsupportedOperationException;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.jdbc.SqlNodeVisitor;

public class WhitespaceNode
extends AbstractSqlNode {
    protected static final Map<String, WhitespaceNode> nodeMap = new HashMap<String, WhitespaceNode>();
    protected final String whitespace;

    private WhitespaceNode(char whitespace) {
        this(String.valueOf(whitespace));
    }

    private WhitespaceNode(String whitespace) {
        AssertionUtil.assertNotNull(whitespace);
        this.whitespace = whitespace;
    }

    public String getWhitespace() {
        return this.whitespace;
    }

    @Override
    public void appendNode(SqlNode child) {
        throw new JdbcUnsupportedOperationException(this.getClass().getName(), "addNode");
    }

    @Override
    public <R, P> R accept(SqlNodeVisitor<R, P> visitor, P p) {
        if (visitor == null) {
            throw new DomaNullPointerException("visitor");
        }
        return visitor.visitWhitespaceNode(this, p);
    }

    public static WhitespaceNode of(String whitespace) {
        WhitespaceNode whitespaceNode = nodeMap.get(whitespace);
        if (whitespaceNode != null) {
            return whitespaceNode;
        }
        return new WhitespaceNode(whitespace);
    }

    static {
        nodeMap.put(String.valueOf('\t'), new WhitespaceNode('\t'));
        nodeMap.put(String.valueOf('\u000b'), new WhitespaceNode('\u000b'));
        nodeMap.put(String.valueOf('\f'), new WhitespaceNode('\f'));
        nodeMap.put(String.valueOf('\u001c'), new WhitespaceNode('\u001c'));
        nodeMap.put(String.valueOf('\u001d'), new WhitespaceNode('\u001d'));
        nodeMap.put(String.valueOf('\u001e'), new WhitespaceNode('\u001e'));
        nodeMap.put(String.valueOf('\u001f'), new WhitespaceNode('\u001f'));
        nodeMap.put(String.valueOf(' '), new WhitespaceNode(' '));
    }
}

