/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.seasar.doma.internal.WrapException;
import org.seasar.doma.internal.util.AssertionUtil;

public final class FieldUtil {
    public static Object get(Field field, Object target) throws WrapException {
        AssertionUtil.assertNotNull(field);
        try {
            return field.get(target);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new WrapException(e);
        }
    }

    public static void set(Field field, Object target, Object value) throws WrapException {
        AssertionUtil.assertNotNull(field);
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new WrapException(e);
        }
    }

    public static void setAccessible(Field field, boolean flag) throws WrapException {
        AssertionUtil.assertNotNull(field);
        try {
            field.setAccessible(flag);
        }
        catch (SecurityException e) {
            throw new WrapException(e);
        }
    }

    public static boolean isPublic(Field field) {
        AssertionUtil.assertNotNull(field);
        return Modifier.isPublic(field.getModifiers());
    }
}

