/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc;

import java.lang.reflect.Method;
import java.util.Optional;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.jdbc.Config;

public class CommentContext {
    protected final String className;
    protected final String methodName;
    protected final Config config;
    protected final Optional<Method> method;
    protected final Optional<String> message;

    public CommentContext(String className, String methodName, Config config, Method method, String message) {
        if (className == null) {
            throw new DomaNullPointerException("className");
        }
        if (methodName == null) {
            throw new DomaNullPointerException("methodName");
        }
        if (config == null) {
            throw new DomaNullPointerException("config");
        }
        this.className = className;
        this.methodName = methodName;
        this.config = config;
        this.method = Optional.ofNullable(method);
        this.message = Optional.ofNullable(message);
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Config getConfig() {
        return this.config;
    }

    public Optional<Method> getMethod() {
        return this.method;
    }

    public Optional<String> getMessage() {
        return this.message;
    }
}

