/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc;

import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.seasar.doma.jdbc.AbstractSqlFileRepository;
import org.seasar.doma.jdbc.SqlFile;
import org.seasar.doma.jdbc.dialect.Dialect;

public class GreedyCacheSqlFileRepository
extends AbstractSqlFileRepository {
    protected final ConcurrentMap<AbstractSqlFileRepository.CacheKey, SqlFile> sqlFileMap = new ConcurrentHashMap<AbstractSqlFileRepository.CacheKey, SqlFile>(200);

    @Override
    protected SqlFile getSqlFileWithCacheControl(Method method, String path, Dialect dialect) {
        AbstractSqlFileRepository.CacheKey key = new AbstractSqlFileRepository.CacheKey(method, path);
        SqlFile file = (SqlFile)this.sqlFileMap.get(key);
        if (file != null) {
            return file;
        }
        file = this.createSqlFile(method, path, dialect);
        SqlFile current = this.sqlFileMap.putIfAbsent(key, file);
        return current != null ? current : file;
    }

    @Override
    public void clearCache() {
        this.sqlFileMap.clear();
    }
}

