/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.builder;

import java.util.List;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.Sql;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.jdbc.builder.BuildingHelper;
import org.seasar.doma.jdbc.builder.Param;
import org.seasar.doma.jdbc.builder.ParamIndex;
import org.seasar.doma.jdbc.command.InsertCommand;
import org.seasar.doma.jdbc.query.SqlInsertQuery;

public class InsertBuilder {
    private final BuildingHelper helper;
    private final SqlInsertQuery query;
    private final ParamIndex paramIndex;

    private InsertBuilder(Config config) {
        this.helper = new BuildingHelper();
        this.query = new SqlInsertQuery();
        this.query.setConfig(config);
        this.query.setCallerClassName(this.getClass().getName());
        this.query.setSqlLogType(SqlLogType.FORMATTED);
        this.paramIndex = new ParamIndex();
    }

    private InsertBuilder(BuildingHelper builder, SqlInsertQuery query, ParamIndex parameterIndex) {
        this.helper = builder;
        this.query = query;
        this.paramIndex = parameterIndex;
    }

    public static InsertBuilder newInstance(Config config) {
        if (config == null) {
            throw new DomaNullPointerException("config");
        }
        return new InsertBuilder(config);
    }

    public InsertBuilder sql(String sql) {
        if (sql == null) {
            throw new DomaNullPointerException("sql");
        }
        this.helper.appendSqlWithLineSeparator(sql);
        return new SubsequentInsertBuilder(this.helper, this.query, this.paramIndex);
    }

    public InsertBuilder removeLast() {
        this.helper.removeLast();
        return new SubsequentInsertBuilder(this.helper, this.query, this.paramIndex);
    }

    public <P> InsertBuilder param(Class<P> paramClass, P param) {
        if (paramClass == null) {
            throw new DomaNullPointerException("paramClass");
        }
        return this.appendParam(paramClass, param, false);
    }

    public <E> InsertBuilder params(Class<E> elementClass, List<E> params) {
        if (elementClass == null) {
            throw new DomaNullPointerException("elementClass");
        }
        if (params == null) {
            throw new DomaNullPointerException("params");
        }
        return this.appendParams(elementClass, params, false);
    }

    public <P> InsertBuilder literal(Class<P> paramClass, P param) {
        if (paramClass == null) {
            throw new DomaNullPointerException("paramClass");
        }
        return this.appendParam(paramClass, param, true);
    }

    public <E> InsertBuilder literals(Class<E> elementClass, List<E> params) {
        if (elementClass == null) {
            throw new DomaNullPointerException("elementClass");
        }
        if (params == null) {
            throw new DomaNullPointerException("params");
        }
        return this.appendParams(elementClass, params, true);
    }

    private <P> InsertBuilder appendParam(Class<P> paramClass, P param, boolean literal) {
        this.helper.appendParam(new Param(paramClass, param, this.paramIndex, literal));
        this.paramIndex.increment();
        return new SubsequentInsertBuilder(this.helper, this.query, this.paramIndex);
    }

    private <E> InsertBuilder appendParams(Class<E> elementClass, List<E> params, boolean literal) {
        InsertBuilder builder = this;
        int index = 0;
        for (E param : params) {
            builder = builder.appendParam(elementClass, param, literal).sql(", ");
            ++index;
        }
        builder = index == 0 ? builder.sql("null") : builder.removeLast();
        return builder;
    }

    public int execute() {
        if (this.query.getMethodName() == null) {
            this.query.setCallerMethodName("execute");
        }
        this.prepare();
        InsertCommand command = new InsertCommand(this.query);
        int result = command.execute();
        this.query.complete();
        return result;
    }

    private void prepare() {
        this.query.clearParameters();
        for (Param p : this.helper.getParams()) {
            this.query.addParameter(p.name, p.paramClass, p.param);
        }
        this.query.setSqlNode(this.helper.getSqlNode());
        this.query.prepare();
    }

    public void queryTimeout(int queryTimeout) {
        this.query.setQueryTimeout(queryTimeout);
    }

    public void sqlLogType(SqlLogType sqlLogType) {
        if (sqlLogType == null) {
            throw new DomaNullPointerException("sqlLogType");
        }
        this.query.setSqlLogType(sqlLogType);
    }

    public void callerClassName(String className) {
        if (className == null) {
            throw new DomaNullPointerException("className");
        }
        this.query.setCallerClassName(className);
    }

    public void callerMethodName(String methodName) {
        if (methodName == null) {
            throw new DomaNullPointerException("methodName");
        }
        this.query.setCallerMethodName(methodName);
    }

    public Sql<?> getSql() {
        if (this.query.getMethodName() == null) {
            this.query.setCallerMethodName("getSql");
        }
        this.prepare();
        return this.query.getSql();
    }

    private static class SubsequentInsertBuilder
    extends InsertBuilder {
        private SubsequentInsertBuilder(BuildingHelper builder, SqlInsertQuery query, ParamIndex parameterIndex) {
            super(builder, query, parameterIndex);
        }

        @Override
        public InsertBuilder sql(String sql) {
            if (sql == null) {
                throw new DomaNullPointerException("sql");
            }
            ((InsertBuilder)this).helper.appendSql(sql);
            return this;
        }
    }
}

