/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.builder;

import java.util.Map;
import org.seasar.doma.DomaIllegalArgumentException;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.Sql;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.jdbc.builder.InsertBuilder;

public class MapInsertBuilder {
    private final InsertBuilder builder;
    private final String tableName;

    private MapInsertBuilder(Config config, String tableName) {
        this.builder = InsertBuilder.newInstance(config);
        this.builder.callerClassName(this.getClass().getName());
        this.tableName = tableName;
    }

    public static MapInsertBuilder newInstance(Config config, String tableName) {
        if (config == null) {
            throw new DomaNullPointerException("config");
        }
        if (tableName == null) {
            throw new DomaNullPointerException("tableName");
        }
        return new MapInsertBuilder(config, tableName);
    }

    public int execute(Map<String, Object> parameter) {
        if (parameter == null) {
            throw new DomaNullPointerException("parameter");
        }
        if (parameter.size() < 1) {
            throw new DomaIllegalArgumentException("parameter", "parameter.size() < 1");
        }
        this.builder.sql("insert into ").sql(this.tableName).sql(" (").sql(String.join((CharSequence)", ", parameter.keySet())).sql(")");
        this.builder.sql("values (");
        parameter.forEach((key, value) -> {
            if (value == null) {
                this.builder.sql("NULL").sql(", ");
            } else {
                Class<?> clazz = value.getClass();
                this.builder.param(clazz, value).sql(", ");
            }
        });
        this.builder.removeLast().sql(")");
        return this.builder.execute();
    }

    public void queryTimeout(int queryTimeout) {
        this.builder.queryTimeout(queryTimeout);
    }

    public void sqlLogType(SqlLogType sqlLogType) {
        this.builder.sqlLogType(sqlLogType);
    }

    public void callerClassName(String className) {
        this.builder.callerClassName(className);
    }

    public void callerMethodName(String methodName) {
        if (methodName == null) {
            throw new DomaNullPointerException("methodName");
        }
        this.builder.callerMethodName(methodName);
    }

    public Sql<?> getSql() {
        return this.builder.getSql();
    }
}

