/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.builder;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.seasar.doma.DomaIllegalArgumentException;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.Entity;
import org.seasar.doma.FetchType;
import org.seasar.doma.MapKeyNamingType;
import org.seasar.doma.internal.jdbc.command.EntityResultListHandler;
import org.seasar.doma.internal.jdbc.command.EntitySingleResultHandler;
import org.seasar.doma.internal.jdbc.command.EntityStreamHandler;
import org.seasar.doma.internal.jdbc.command.MapResultListHandler;
import org.seasar.doma.internal.jdbc.command.MapSingleResultHandler;
import org.seasar.doma.internal.jdbc.command.MapStreamHandler;
import org.seasar.doma.internal.jdbc.command.OptionalEntitySingleResultHandler;
import org.seasar.doma.internal.jdbc.command.OptionalMapSingleResultHandler;
import org.seasar.doma.internal.jdbc.command.ScalarResultListHandler;
import org.seasar.doma.internal.jdbc.command.ScalarSingleResultHandler;
import org.seasar.doma.internal.jdbc.command.ScalarStreamHandler;
import org.seasar.doma.internal.jdbc.scalar.Scalar;
import org.seasar.doma.internal.jdbc.scalar.ScalarException;
import org.seasar.doma.internal.jdbc.scalar.Scalars;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.SelectOptions;
import org.seasar.doma.jdbc.Sql;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.jdbc.builder.BuildingHelper;
import org.seasar.doma.jdbc.builder.Param;
import org.seasar.doma.jdbc.builder.ParamIndex;
import org.seasar.doma.jdbc.command.ResultSetHandler;
import org.seasar.doma.jdbc.command.SelectCommand;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.EntityTypeFactory;
import org.seasar.doma.jdbc.query.SqlSelectQuery;
import org.seasar.doma.message.Message;

public class SelectBuilder {
    private final Config config;
    private final BuildingHelper helper;
    private final SqlSelectQuery query;
    private final ParamIndex paramIndex;

    private SelectBuilder(Config config) {
        this.config = config;
        this.helper = new BuildingHelper();
        this.query = new SqlSelectQuery();
        this.query.setConfig(config);
        this.query.setCallerClassName(this.getClass().getName());
        this.query.setFetchType(FetchType.LAZY);
        this.query.setSqlLogType(SqlLogType.FORMATTED);
        this.paramIndex = new ParamIndex();
    }

    private SelectBuilder(Config config, BuildingHelper builder, SqlSelectQuery query, ParamIndex parameterIndex) {
        this.config = config;
        this.helper = builder;
        this.query = query;
        this.paramIndex = parameterIndex;
    }

    public static SelectBuilder newInstance(Config config) {
        if (config == null) {
            throw new DomaNullPointerException("config");
        }
        return new SelectBuilder(config);
    }

    public SelectBuilder sql(String sql) {
        if (sql == null) {
            throw new DomaNullPointerException("sql");
        }
        this.helper.appendSqlWithLineSeparator(sql);
        return new SubsequentSelectBuilder(this.config, this.helper, this.query, this.paramIndex);
    }

    public SelectBuilder removeLast() {
        this.helper.removeLast();
        return new SubsequentSelectBuilder(this.config, this.helper, this.query, this.paramIndex);
    }

    public <P> SelectBuilder param(Class<P> paramClass, P param) {
        if (paramClass == null) {
            throw new DomaNullPointerException("paramClass");
        }
        return this.appendParam(paramClass, param, false);
    }

    public <E> SelectBuilder params(Class<E> elementClass, List<E> params) {
        if (elementClass == null) {
            throw new DomaNullPointerException("elementClass");
        }
        if (params == null) {
            throw new DomaNullPointerException("params");
        }
        return this.appendParams(elementClass, params, false);
    }

    public <P> SelectBuilder literal(Class<P> paramClass, P param) {
        if (paramClass == null) {
            throw new DomaNullPointerException("paramClass");
        }
        return this.appendParam(paramClass, param, true);
    }

    public <E> SelectBuilder literals(Class<E> elementClass, List<E> params) {
        if (elementClass == null) {
            throw new DomaNullPointerException("elementClass");
        }
        if (params == null) {
            throw new DomaNullPointerException("params");
        }
        return this.appendParams(elementClass, params, true);
    }

    private <P> SelectBuilder appendParam(Class<P> paramClass, P param, boolean literal) {
        this.helper.appendParam(new Param(paramClass, param, this.paramIndex, literal));
        this.paramIndex.increment();
        return new SubsequentSelectBuilder(this.config, this.helper, this.query, this.paramIndex);
    }

    private <E> SelectBuilder appendParams(Class<E> elementClass, List<E> params, boolean literal) {
        SelectBuilder builder = this;
        int index = 0;
        for (E param : params) {
            builder = builder.appendParam(elementClass, param, literal).sql(", ");
            ++index;
        }
        builder = index == 0 ? builder.sql("null") : builder.removeLast();
        return builder;
    }

    public <RESULT> RESULT getEntitySingleResult(Class<RESULT> resultClass) {
        if (resultClass == null) {
            throw new DomaNullPointerException("resultClass");
        }
        if (!resultClass.isAnnotationPresent(Entity.class)) {
            throw new DomaIllegalArgumentException("resultClass", Message.DOMA2219.getMessage(resultClass));
        }
        if (this.query.getMethodName() == null) {
            this.query.setCallerMethodName("getEntitySingleResult");
        }
        EntityType<RESULT> entityType = EntityTypeFactory.getEntityType(resultClass, this.config.getClassHelper());
        this.query.setEntityType(entityType);
        EntitySingleResultHandler<RESULT> handler = new EntitySingleResultHandler<RESULT>(entityType);
        return this.execute(handler);
    }

    public <RESULT> Optional<RESULT> getOptionalEntitySingleResult(Class<RESULT> resultClass) {
        if (resultClass == null) {
            throw new DomaNullPointerException("resultClass");
        }
        if (!resultClass.isAnnotationPresent(Entity.class)) {
            throw new DomaIllegalArgumentException("resultClass", Message.DOMA2219.getMessage(resultClass));
        }
        if (this.query.getMethodName() == null) {
            this.query.setCallerMethodName("getOptionalEntitySingleResult");
        }
        EntityType<RESULT> entityType = EntityTypeFactory.getEntityType(resultClass, this.config.getClassHelper());
        this.query.setEntityType(entityType);
        OptionalEntitySingleResultHandler<RESULT> handler = new OptionalEntitySingleResultHandler<RESULT>(entityType);
        return (Optional)this.execute(handler);
    }

    public <RESULT> RESULT getScalarSingleResult(Class<RESULT> resultClass) {
        if (resultClass == null) {
            throw new DomaNullPointerException("resultClass");
        }
        if (this.query.getMethodName() == null) {
            this.query.setCallerMethodName("getScalarSingleResult");
        }
        Supplier supplier = this.createScalarSupplier("resultClass", resultClass, false);
        ScalarSingleResultHandler handler = new ScalarSingleResultHandler(supplier);
        return this.execute(handler);
    }

    public <RESULT> Optional<RESULT> getOptionalScalarSingleResult(Class<RESULT> resultClass) {
        if (resultClass == null) {
            throw new DomaNullPointerException("resultClass");
        }
        if (this.query.getMethodName() == null) {
            this.query.setCallerMethodName("getOptionalScalarSingleResult");
        }
        Supplier supplier = this.createScalarSupplier("resultClass", resultClass, true);
        ScalarSingleResultHandler handler = new ScalarSingleResultHandler(supplier);
        return (Optional)this.execute(handler);
    }

    public Map<String, Object> getMapSingleResult(MapKeyNamingType mapKeyNamingType) {
        if (mapKeyNamingType == null) {
            throw new DomaNullPointerException("mapKeyNamingType");
        }
        if (this.query.getMethodName() == null) {
            this.query.setCallerMethodName("getMapSingleResult");
        }
        MapSingleResultHandler handler = new MapSingleResultHandler(mapKeyNamingType);
        return this.execute(handler);
    }

    public Optional<Map<String, Object>> getOptionalMapSingleResult(MapKeyNamingType mapKeyNamingType) {
        if (mapKeyNamingType == null) {
            throw new DomaNullPointerException("mapKeyNamingType");
        }
        if (this.query.getMethodName() == null) {
            this.query.setCallerMethodName("getOptionalMapSingleResult");
        }
        OptionalMapSingleResultHandler handler = new OptionalMapSingleResultHandler(mapKeyNamingType);
        return this.execute(handler);
    }

    public <ELEMENT> List<ELEMENT> getEntityResultList(Class<ELEMENT> elementClass) {
        if (elementClass == null) {
            throw new DomaNullPointerException("elementClass");
        }
        if (!elementClass.isAnnotationPresent(Entity.class)) {
            throw new DomaIllegalArgumentException("elementClass", Message.DOMA2219.getMessage(elementClass));
        }
        if (this.query.getMethodName() == null) {
            this.query.setCallerMethodName("getEntityResultList");
        }
        EntityType<ELEMENT> entityType = EntityTypeFactory.getEntityType(elementClass, this.config.getClassHelper());
        this.query.setEntityType(entityType);
        EntityResultListHandler<ELEMENT> handler = new EntityResultListHandler<ELEMENT>(entityType);
        return (List)this.execute(handler);
    }

    public <ELEMENT> List<ELEMENT> getScalarResultList(Class<ELEMENT> elementClass) {
        if (elementClass == null) {
            throw new DomaNullPointerException("elementClass");
        }
        if (this.query.getMethodName() == null) {
            this.query.setCallerMethodName("getScalarResultList");
        }
        Supplier supplier = this.createScalarSupplier("elementClass", elementClass, false);
        ScalarResultListHandler handler = new ScalarResultListHandler(supplier);
        return (List)this.execute(handler);
    }

    public <ELEMENT> List<Optional<ELEMENT>> getOptionalScalarResultList(Class<ELEMENT> elementClass) {
        if (elementClass == null) {
            throw new DomaNullPointerException("elementClass");
        }
        if (this.query.getMethodName() == null) {
            this.query.setCallerMethodName("getOptionalScalarResultList");
        }
        Supplier supplier = this.createScalarSupplier("elementClass", elementClass, true);
        ScalarResultListHandler handler = new ScalarResultListHandler(supplier);
        return (List)this.execute(handler);
    }

    public List<Map<String, Object>> getMapResultList(MapKeyNamingType mapKeyNamingType) {
        if (mapKeyNamingType == null) {
            throw new DomaNullPointerException("mapKeyNamingType");
        }
        if (this.query.getMethodName() == null) {
            this.query.setCallerMethodName("getMapResultList");
        }
        MapResultListHandler handler = new MapResultListHandler(mapKeyNamingType);
        return this.execute(handler);
    }

    public <TARGET> Stream<TARGET> streamEntity(Class<TARGET> targetClass) {
        if (targetClass == null) {
            throw new DomaNullPointerException("targetClass");
        }
        if (!targetClass.isAnnotationPresent(Entity.class)) {
            throw new DomaIllegalArgumentException("targetClass", Message.DOMA2219.getMessage(targetClass));
        }
        this.query.setResultStream(true);
        return (Stream)this.streamEntityInternal(targetClass, Function.identity());
    }

    public <TARGET, RESULT> RESULT streamEntity(Class<TARGET> targetClass, Function<Stream<TARGET>, RESULT> mapper) {
        if (targetClass == null) {
            throw new DomaNullPointerException("targetClass");
        }
        if (!targetClass.isAnnotationPresent(Entity.class)) {
            throw new DomaIllegalArgumentException("targetClass", Message.DOMA2219.getMessage(targetClass));
        }
        if (mapper == null) {
            throw new DomaNullPointerException("mapper");
        }
        return this.streamEntityInternal(targetClass, mapper);
    }

    protected <TARGET, RESULT> RESULT streamEntityInternal(Class<TARGET> targetClass, Function<Stream<TARGET>, RESULT> mapper) {
        if (this.query.getMethodName() == null) {
            this.query.setCallerMethodName("streamEntity");
        }
        EntityType<TARGET> entityType = EntityTypeFactory.getEntityType(targetClass, this.config.getClassHelper());
        this.query.setEntityType(entityType);
        EntityStreamHandler<TARGET, RESULT> handler = new EntityStreamHandler<TARGET, RESULT>(entityType, mapper);
        return this.execute(handler);
    }

    public <TARGET> Stream<TARGET> streamScalar(Class<TARGET> targetClass) {
        if (targetClass == null) {
            throw new DomaNullPointerException("targetClass");
        }
        this.query.setResultStream(true);
        return (Stream)this.streamScalarInternal(targetClass, Function.identity());
    }

    public <RESULT, TARGET> RESULT streamScalar(Class<TARGET> targetClass, Function<Stream<TARGET>, RESULT> mapper) {
        if (targetClass == null) {
            throw new DomaNullPointerException("targetClass");
        }
        if (mapper == null) {
            throw new DomaNullPointerException("mapper");
        }
        return this.streamScalarInternal(targetClass, mapper);
    }

    protected <RESULT, TARGET> RESULT streamScalarInternal(Class<TARGET> targetClass, Function<Stream<TARGET>, RESULT> mapper) {
        if (this.query.getMethodName() == null) {
            this.query.setCallerMethodName("streamScalar");
        }
        Supplier supplier = this.createScalarSupplier("targetClass", targetClass, false);
        ScalarStreamHandler handler = new ScalarStreamHandler(supplier, mapper);
        return this.execute(handler);
    }

    public <TARGET> Stream<Optional<TARGET>> streamOptionalScalar(Class<TARGET> targetClass) {
        if (targetClass == null) {
            throw new DomaNullPointerException("targetClass");
        }
        this.query.setResultStream(true);
        return (Stream)this.streamOptionalScalarInternal(targetClass, Function.identity());
    }

    public <RESULT, TARGET> RESULT streamOptionalScalar(Class<TARGET> targetClass, Function<Stream<Optional<TARGET>>, RESULT> mapper) {
        if (targetClass == null) {
            throw new DomaNullPointerException("targetClass");
        }
        if (mapper == null) {
            throw new DomaNullPointerException("mapper");
        }
        return this.streamOptionalScalarInternal(targetClass, mapper);
    }

    protected <RESULT, TARGET> RESULT streamOptionalScalarInternal(Class<TARGET> targetClass, Function<Stream<Optional<TARGET>>, RESULT> mapper) {
        if (this.query.getMethodName() == null) {
            this.query.setCallerMethodName("streamOptionalScalar");
        }
        Supplier supplier = this.createScalarSupplier("targetClass", targetClass, true);
        ScalarStreamHandler handler = new ScalarStreamHandler(supplier, mapper);
        return this.execute(handler);
    }

    public Stream<Map<String, Object>> streamMap(MapKeyNamingType mapKeyNamingType) {
        if (mapKeyNamingType == null) {
            throw new DomaNullPointerException("mapKeyNamingType");
        }
        this.query.setResultStream(true);
        return (Stream)this.streamMapInternal(mapKeyNamingType, Function.identity());
    }

    public <RESULT> RESULT streamMap(MapKeyNamingType mapKeyNamingType, Function<Stream<Map<String, Object>>, RESULT> mapper) {
        if (mapKeyNamingType == null) {
            throw new DomaNullPointerException("mapKeyNamingType");
        }
        if (mapper == null) {
            throw new DomaNullPointerException("mapper");
        }
        return this.streamMapInternal(mapKeyNamingType, mapper);
    }

    protected <RESULT> RESULT streamMapInternal(MapKeyNamingType mapKeyNamingType, Function<Stream<Map<String, Object>>, RESULT> mapper) {
        if (this.query.getMethodName() == null) {
            this.query.setCallerMethodName("streamMap");
        }
        MapStreamHandler<RESULT> handler = new MapStreamHandler<RESULT>(mapKeyNamingType, mapper);
        return this.execute(handler);
    }

    private <RESULT> RESULT execute(ResultSetHandler<RESULT> resultSetHandler) {
        this.prepare();
        SelectCommand<RESULT> command = new SelectCommand<RESULT>(this.query, resultSetHandler);
        RESULT result = command.execute();
        this.query.complete();
        return result;
    }

    private void prepare() {
        this.query.clearParameters();
        for (Param p : this.helper.getParams()) {
            this.query.addParameter(p.name, p.paramClass, p.param);
        }
        this.query.setSqlNode(this.helper.getSqlNode());
        this.query.prepare();
    }

    public void ensureResult(boolean ensureResult) {
        this.query.setResultEnsured(ensureResult);
    }

    public void ensureResultMapping(boolean ensureResultMapping) {
        this.query.setResultMappingEnsured(ensureResultMapping);
    }

    public void fetch(FetchType fetchType) {
        this.query.setFetchType(fetchType);
    }

    public void fetchSize(int fetchSize) {
        this.query.setFetchSize(fetchSize);
    }

    public void maxRows(int maxRows) {
        this.query.setMaxRows(maxRows);
    }

    public void queryTimeout(int queryTimeout) {
        this.query.setQueryTimeout(queryTimeout);
    }

    public void sqlLogType(SqlLogType sqlLogType) {
        if (sqlLogType == null) {
            throw new DomaNullPointerException("sqlLogType");
        }
        this.query.setSqlLogType(sqlLogType);
    }

    public void callerClassName(String className) {
        if (className == null) {
            throw new DomaNullPointerException("className");
        }
        this.query.setCallerClassName(className);
    }

    public void callerMethodName(String methodName) {
        if (methodName == null) {
            throw new DomaNullPointerException("methodName");
        }
        this.query.setCallerMethodName(methodName);
    }

    public void options(SelectOptions options) {
        if (options == null) {
            throw new DomaNullPointerException("options");
        }
        this.query.setOptions(options);
    }

    public Sql<?> getSql() {
        if (this.query.getMethodName() == null) {
            this.query.setCallerMethodName("getSql");
        }
        this.prepare();
        return this.query.getSql();
    }

    private Supplier<Scalar<?, ?>> createScalarSupplier(String parameterName, Class<?> clazz, boolean optional) {
        try {
            return Scalars.wrap(null, clazz, optional, this.config.getClassHelper());
        }
        catch (ScalarException e) {
            throw new DomaIllegalArgumentException(parameterName, Message.DOMA2204.getMessage(clazz, e));
        }
    }

    private static class SubsequentSelectBuilder
    extends SelectBuilder {
        private SubsequentSelectBuilder(Config config, BuildingHelper builder, SqlSelectQuery query, ParamIndex paramIndex) {
            super(config, builder, query, paramIndex);
        }

        @Override
        public SelectBuilder sql(String fragment) {
            ((SelectBuilder)this).helper.appendSql(fragment);
            return this;
        }
    }
}

