/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.command;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.seasar.doma.jdbc.BatchUniqueConstraintException;
import org.seasar.doma.jdbc.PreparedSql;
import org.seasar.doma.jdbc.command.BatchModifyCommand;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.query.BatchInsertQuery;

public class BatchInsertCommand
extends BatchModifyCommand<BatchInsertQuery> {
    public BatchInsertCommand(BatchInsertQuery query) {
        super(query);
    }

    @Override
    protected int[] executeInternal(PreparedStatement preparedStatement, List<PreparedSql> sqls) throws SQLException {
        if (((BatchInsertQuery)this.query).isBatchSupported()) {
            return this.executeBatch(preparedStatement, sqls);
        }
        int sqlSize = sqls.size();
        int[] updatedRows = new int[sqlSize];
        int i = 0;
        for (PreparedSql sql : sqls) {
            this.log(sql);
            this.bindParameters(preparedStatement, sql);
            updatedRows[i] = this.executeUpdate(preparedStatement, sql);
            ((BatchInsertQuery)this.query).generateId(preparedStatement, i);
            ++i;
        }
        return updatedRows;
    }

    protected int executeUpdate(PreparedStatement preparedStatement, PreparedSql sql) throws SQLException {
        try {
            return preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            Dialect dialect = ((BatchInsertQuery)this.query).getConfig().getDialect();
            if (dialect.isUniqueConstraintViolated(e)) {
                throw new BatchUniqueConstraintException(((BatchInsertQuery)this.query).getConfig().getExceptionSqlLogType(), sql, e);
            }
            throw e;
        }
    }
}

