/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.command;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.seasar.doma.internal.util.Combinations;
import org.seasar.doma.internal.util.Pair;
import org.seasar.doma.jdbc.command.Command;
import org.seasar.doma.jdbc.command.SelectCommand;
import org.seasar.doma.jdbc.criteria.command.EntityData;
import org.seasar.doma.jdbc.criteria.command.EntityKey;
import org.seasar.doma.jdbc.criteria.command.EntityPool;
import org.seasar.doma.jdbc.criteria.command.EntityPoolIterationHandler;
import org.seasar.doma.jdbc.criteria.context.SelectContext;
import org.seasar.doma.jdbc.criteria.metamodel.EntityMetamodel;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.query.Query;
import org.seasar.doma.jdbc.query.SelectQuery;

public class AssociateCommand<ENTITY>
implements Command<List<ENTITY>> {
    private final SelectContext context;
    private final SelectQuery query;
    private final EntityMetamodel<ENTITY> entityMetamodel;

    public AssociateCommand(SelectContext context, SelectQuery query, EntityMetamodel<ENTITY> entityMetamodel) {
        this.context = Objects.requireNonNull(context);
        this.query = Objects.requireNonNull(query);
        this.entityMetamodel = Objects.requireNonNull(entityMetamodel);
    }

    @Override
    public List<ENTITY> execute() {
        LinkedHashMap<EntityKey, Object> cache = new LinkedHashMap<EntityKey, Object>();
        Combinations<EntityKey> combinations = new Combinations<EntityKey>();
        SelectCommand<List<EntityPool>> command = new SelectCommand<List<EntityPool>>(this.query, new EntityPoolIterationHandler(this.context.getProjectionEntityMetamodels()));
        List<EntityPool> entityPools = command.execute();
        for (EntityPool entityPool : entityPools) {
            LinkedHashMap associationCandidate = new LinkedHashMap();
            for (Map.Entry<EntityKey, EntityData> e2 : entityPool.entrySet()) {
                EntityKey key = e2.getKey();
                EntityData data = e2.getValue();
                Object entity = cache.computeIfAbsent(key, k -> {
                    EntityMetamodel<?> entityMetamodel = k.getEntityMetamodel();
                    EntityType<?> entityType = entityMetamodel.asType();
                    Object newEntity = entityType.newEntity(data.getStates());
                    if (!entityType.isImmutable()) {
                        entityType.saveCurrentStates(newEntity);
                    }
                    return newEntity;
                });
                associationCandidate.put(key.getEntityMetamodel(), new Pair<EntityKey, Object>(key, entity));
            }
            this.associate(cache, combinations, associationCandidate);
        }
        return cache.entrySet().stream().filter(e -> ((EntityKey)e.getKey()).getEntityMetamodel() == this.entityMetamodel).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    private void associate(Map<EntityKey, Object> cache, Combinations<EntityKey> combinations, Map<EntityMetamodel<?>, Pair<EntityKey, Object>> associationCandidate) {
        for (Map.Entry<Pair<EntityMetamodel<?>, EntityMetamodel<?>>, BiFunction<Object, Object, Object>> e : this.context.associations.entrySet()) {
            Pair keyPair;
            Pair<EntityMetamodel<?>, EntityMetamodel<?>> metamodelPair = e.getKey();
            BiFunction<Object, Object, Object> associator = e.getValue();
            Pair<EntityKey, Object> keyAndEntity1 = associationCandidate.get(metamodelPair.fst);
            Pair<EntityKey, Object> keyAndEntity2 = associationCandidate.get(metamodelPair.snd);
            if (keyAndEntity1 == null || keyAndEntity2 == null || combinations.contains(keyPair = new Pair(keyAndEntity1.fst, keyAndEntity2.fst))) continue;
            Object newEntity = associator.apply(keyAndEntity1.snd, keyAndEntity2.snd);
            if (newEntity != null) {
                cache.replace((EntityKey)keyAndEntity1.fst, newEntity);
                associationCandidate.replace((EntityMetamodel<?>)metamodelPair.fst, new Pair(keyAndEntity1.fst, newEntity));
            }
            combinations.add(keyPair);
        }
    }

    @Override
    public Query getQuery() {
        return this.query;
    }
}

