/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.query;

import java.util.Objects;
import java.util.function.Function;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.InParameter;
import org.seasar.doma.jdbc.PreparedSql;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.jdbc.criteria.context.InsertContext;
import org.seasar.doma.jdbc.criteria.context.Operand;
import org.seasar.doma.jdbc.criteria.metamodel.EntityMetamodel;
import org.seasar.doma.jdbc.criteria.metamodel.PropertyMetamodel;
import org.seasar.doma.jdbc.criteria.query.AliasManager;
import org.seasar.doma.jdbc.criteria.query.SelectBuilder;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;

public class InsertBuilder {
    private final Config config;
    private final InsertContext context;
    private final Function<String, String> commenter;
    private final PreparedSqlBuilder buf;

    public InsertBuilder(Config config, InsertContext context, Function<String, String> commenter, SqlLogType sqlLogType) {
        this(config, context, commenter, new PreparedSqlBuilder(config, SqlKind.INSERT, sqlLogType));
    }

    public InsertBuilder(Config config, InsertContext context, Function<String, String> commenter, PreparedSqlBuilder buf) {
        this.config = Objects.requireNonNull(config);
        this.context = Objects.requireNonNull(context);
        this.commenter = Objects.requireNonNull(commenter);
        this.buf = Objects.requireNonNull(buf);
    }

    public PreparedSql build() {
        this.buf.appendSql("insert into ");
        this.table(this.context.entityMetamodel);
        if (!this.context.values.isEmpty()) {
            this.values();
        } else if (this.context.selectContext != null) {
            this.select();
        }
        return this.buf.build(this.commenter);
    }

    private void values() {
        this.buf.appendSql(" (");
        this.context.values.keySet().forEach(key -> {
            this.column((Operand.Prop)key);
            this.buf.appendSql(", ");
        });
        this.buf.cutBackSql(2);
        this.buf.appendSql(") values (");
        this.context.values.values().forEach(value -> {
            this.param((Operand.Param)value);
            this.buf.appendSql(", ");
        });
        this.buf.cutBackSql(2);
        this.buf.appendSql(")");
    }

    private void select() {
        this.buf.appendSql(" (");
        this.context.entityMetamodel.allPropertyMetamodels().forEach(p -> {
            this.column((PropertyMetamodel<?>)p);
            this.buf.appendSql(", ");
        });
        this.buf.cutBackSql(2);
        this.buf.appendSql(") ");
        AliasManager aliasManager = new AliasManager(this.context.selectContext);
        SelectBuilder builder = new SelectBuilder(this.config, this.context.selectContext, Function.identity(), this.buf, aliasManager);
        builder.interpret();
    }

    private void table(EntityMetamodel<?> entityMetamodel) {
        EntityType<?> entityType = entityMetamodel.asType();
        this.buf.appendSql(entityType.getQualifiedTableName(this.config.getNaming()::apply, this.config.getDialect()::applyQuote));
    }

    private void column(Operand.Prop prop) {
        this.column(prop.value);
    }

    private void column(PropertyMetamodel<?> propertyMetamodel) {
        EntityPropertyType<?, ?> propertyType = propertyMetamodel.asType();
        this.buf.appendSql(propertyType.getColumnName(this.config.getNaming()::apply, this.config.getDialect()::applyQuote));
    }

    private void param(Operand.Param param) {
        InParameter<?> parameter = param.createInParameter(this.config);
        this.buf.appendParameter(parameter);
    }
}

