/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.statement;

import java.util.Objects;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.Result;
import org.seasar.doma.jdbc.command.Command;
import org.seasar.doma.jdbc.command.InsertCommand;
import org.seasar.doma.jdbc.criteria.context.InsertSettings;
import org.seasar.doma.jdbc.criteria.metamodel.EntityMetamodel;
import org.seasar.doma.jdbc.criteria.metamodel.PropertyMetamodel;
import org.seasar.doma.jdbc.criteria.statement.AbstractStatement;
import org.seasar.doma.jdbc.criteria.statement.Statement;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.query.AutoInsertQuery;
import org.seasar.doma.jdbc.query.DuplicateKeyType;
import org.seasar.doma.jdbc.query.Query;

public class EntityqlInsertStatement<ENTITY>
extends AbstractStatement<EntityqlInsertStatement<ENTITY>, Result<ENTITY>> {
    private final EntityMetamodel<ENTITY> entityMetamodel;
    private final ENTITY entity;
    private final InsertSettings settings;
    private DuplicateKeyType duplicateKeyType = DuplicateKeyType.EXCEPTION;

    public EntityqlInsertStatement(Config config, EntityMetamodel<ENTITY> entityMetamodel, ENTITY entity, InsertSettings settings) {
        super(Objects.requireNonNull(config));
        this.entityMetamodel = Objects.requireNonNull(entityMetamodel);
        this.entity = Objects.requireNonNull(entity);
        this.settings = Objects.requireNonNull(settings);
    }

    public Statement<Result<ENTITY>> onDuplicateKeyUpdate() {
        this.duplicateKeyType = DuplicateKeyType.UPDATE;
        return this;
    }

    public Statement<Result<ENTITY>> onDuplicateKeyIgnore() {
        this.duplicateKeyType = DuplicateKeyType.IGNORE;
        return this;
    }

    @Override
    public Result<ENTITY> execute() {
        return (Result)super.execute();
    }

    @Override
    protected Command<Result<ENTITY>> createCommand() {
        EntityType<ENTITY> entityType = this.entityMetamodel.asType();
        final AutoInsertQuery<ENTITY> query = this.config.getQueryImplementors().createAutoInsertQuery(EXECUTE_METHOD, entityType);
        query.setMethod(EXECUTE_METHOD);
        query.setConfig(this.config);
        query.setEntity(this.entity);
        query.setCallerClassName(this.getClass().getName());
        query.setCallerMethodName("execute");
        query.setQueryTimeout(this.settings.getQueryTimeout());
        query.setSqlLogType(this.settings.getSqlLogType());
        query.setNullExcluded(this.settings.getExcludeNull());
        query.setIncludedPropertyNames((String[])this.settings.include().stream().map(PropertyMetamodel::getName).toArray(String[]::new));
        query.setExcludedPropertyNames((String[])this.settings.exclude().stream().map(PropertyMetamodel::getName).toArray(String[]::new));
        query.setMessage(this.settings.getComment());
        query.setDuplicateKeyType(this.duplicateKeyType);
        query.prepare();
        final InsertCommand command = this.config.getCommandImplementors().createInsertCommand(EXECUTE_METHOD, query);
        return new Command<Result<ENTITY>>(){

            @Override
            public Query getQuery() {
                return query;
            }

            @Override
            public Result<ENTITY> execute() {
                int count = command.execute();
                query.complete();
                return new Result(count, query.getEntity());
            }
        };
    }
}

