/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.statement;

import java.util.List;
import java.util.Objects;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.PreparedSql;
import org.seasar.doma.jdbc.command.Command;
import org.seasar.doma.jdbc.criteria.command.AssociateCommand;
import org.seasar.doma.jdbc.criteria.context.SelectContext;
import org.seasar.doma.jdbc.criteria.context.SelectSettings;
import org.seasar.doma.jdbc.criteria.declaration.SelectFromDeclaration;
import org.seasar.doma.jdbc.criteria.metamodel.EntityMetamodel;
import org.seasar.doma.jdbc.criteria.query.CriteriaQuery;
import org.seasar.doma.jdbc.criteria.query.SelectBuilder;
import org.seasar.doma.jdbc.criteria.statement.AbstractStatement;
import org.seasar.doma.jdbc.criteria.statement.EmptyWhereClauseException;
import org.seasar.doma.jdbc.criteria.statement.Listable;

public class EntityqlSelectTerminal<ENTITY>
extends AbstractStatement<EntityqlSelectTerminal<ENTITY>, List<ENTITY>>
implements Listable<ENTITY> {
    private final SelectFromDeclaration declaration;
    private final EntityMetamodel<ENTITY> entityMetamodel;

    public EntityqlSelectTerminal(Config config, SelectFromDeclaration declaration, EntityMetamodel<ENTITY> entityMetamodel) {
        super(Objects.requireNonNull(config));
        this.declaration = Objects.requireNonNull(declaration);
        this.entityMetamodel = Objects.requireNonNull(entityMetamodel);
    }

    @Override
    public List<ENTITY> execute() {
        return (List)super.execute();
    }

    @Override
    protected Command<List<ENTITY>> createCommand() {
        final SelectContext context = this.declaration.getContext();
        final SelectSettings settings = context.getSettings();
        SelectBuilder builder = new SelectBuilder(this.config, context, this.createCommenter(settings.getComment()), settings.getSqlLogType());
        final PreparedSql sql = builder.build();
        CriteriaQuery query = new CriteriaQuery(this.config, sql, this.getClass().getName(), "execute");
        query.setFetchSize(settings.getFetchSize());
        query.setMaxRows(settings.getMaxRows());
        query.setQueryTimeout(settings.getQueryTimeout());
        return new AssociateCommand<ENTITY>(context, query, this.entityMetamodel){

            @Override
            public List<ENTITY> execute() {
                if (!settings.getAllowEmptyWhere() && context.where.isEmpty()) {
                    throw new EmptyWhereClauseException(sql);
                }
                return super.execute();
            }
        };
    }
}

