/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.statement;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.PreparedSql;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.command.Command;
import org.seasar.doma.jdbc.command.InsertCommand;
import org.seasar.doma.jdbc.criteria.context.InsertContext;
import org.seasar.doma.jdbc.criteria.context.InsertSettings;
import org.seasar.doma.jdbc.criteria.context.Operand;
import org.seasar.doma.jdbc.criteria.declaration.InsertDeclaration;
import org.seasar.doma.jdbc.criteria.metamodel.PropertyMetamodel;
import org.seasar.doma.jdbc.criteria.query.CriteriaQuery;
import org.seasar.doma.jdbc.criteria.statement.AbstractStatement;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.query.QueryOperand;
import org.seasar.doma.jdbc.query.QueryOperandPair;
import org.seasar.doma.jdbc.query.UpsertAssembler;
import org.seasar.doma.jdbc.query.UpsertAssemblerContext;
import org.seasar.doma.jdbc.query.UpsertAssemblerContextBuilder;

public class NativeSqlUpsertTerminal
extends AbstractStatement<NativeSqlUpsertTerminal, Integer> {
    private final InsertDeclaration declaration;

    public NativeSqlUpsertTerminal(Config config, InsertDeclaration declaration) {
        super(Objects.requireNonNull(config));
        Objects.requireNonNull(declaration);
        this.declaration = declaration;
    }

    @Override
    public Integer execute() {
        return (Integer)super.execute();
    }

    @Override
    protected Command<Integer> createCommand() {
        InsertContext context = this.declaration.getContext();
        InsertSettings settings = context.getSettings();
        PreparedSql sql = this.createPreparedSql(settings, context);
        CriteriaQuery query = new CriteriaQuery(this.config, sql, this.getClass().getName(), "execute");
        query.setQueryTimeout(settings.getQueryTimeout());
        return new InsertCommand(query);
    }

    private PreparedSql createPreparedSql(InsertSettings settings, InsertContext context) {
        List<EntityPropertyType<?, ?>> keys = this.prepareKeys(context.onDuplicateContext.keys);
        List<QueryOperandPair> insertValues = this.prepareInsertValues(context.values);
        List<QueryOperandPair> setValues = this.prepareSetValues(context.onDuplicateContext.setValues);
        PreparedSqlBuilder sqlBuilder = this.assembleQuery(settings, context, keys, insertValues, setValues);
        return sqlBuilder.build(this.createCommenter(settings.getComment()));
    }

    private List<EntityPropertyType<?, ?>> prepareKeys(List<PropertyMetamodel<?>> propertyMetamodels) {
        return propertyMetamodels.stream().map(PropertyMetamodel::asType).collect(Collectors.toList());
    }

    private List<QueryOperandPair> prepareInsertValues(Map<Operand.Prop, Operand.Param> insertContextValue) {
        ArrayList<QueryOperandPair> list = new ArrayList<QueryOperandPair>(insertContextValue.size());
        for (Map.Entry<Operand.Prop, Operand.Param> entry : insertContextValue.entrySet()) {
            Operand.Prop prop = entry.getKey();
            Operand.Param param = entry.getValue();
            QueryOperand.Prop left = new QueryOperand.Prop(prop.getPropertyMetamodel().asType());
            QueryOperand.Param right = new QueryOperand.Param(param.getPropertyMetamodel().asType(), param.createInParameter(this.config));
            QueryOperandPair pair = new QueryOperandPair(left, right);
            list.add(pair);
        }
        return list;
    }

    private List<QueryOperandPair> prepareSetValues(Map<Operand.Prop, Operand> upsertSetValues) {
        ArrayList<QueryOperandPair> list = new ArrayList<QueryOperandPair>(upsertSetValues.size());
        for (Map.Entry<Operand.Prop, Operand> upsertSetValue : upsertSetValues.entrySet()) {
            Operand.Prop prop = upsertSetValue.getKey();
            Operand operand = upsertSetValue.getValue();
            QueryOperand.Prop left = new QueryOperand.Prop(prop.getPropertyMetamodel().asType());
            QueryOperand right = operand.accept(new OperandVisitor());
            QueryOperandPair pair = new QueryOperandPair(left, right);
            list.add(pair);
        }
        return list;
    }

    private PreparedSqlBuilder assembleQuery(InsertSettings settings, InsertContext context, List<EntityPropertyType<?, ?>> keys, List<QueryOperandPair> insertValues, List<QueryOperandPair> setValues) {
        PreparedSqlBuilder sql = new PreparedSqlBuilder(this.config, SqlKind.INSERT, settings.getSqlLogType());
        UpsertAssemblerContext upsertAssemblerContext = UpsertAssemblerContextBuilder.build(sql, context.entityMetamodel.asType(), context.onDuplicateContext.duplicateKeyType, this.config.getNaming(), this.config.getDialect(), keys, insertValues, setValues);
        UpsertAssembler upsertQuery = this.config.getDialect().getUpsertAssembler(upsertAssemblerContext);
        upsertQuery.assemble();
        return sql;
    }

    private class OperandVisitor
    implements Operand.Visitor<QueryOperand> {
        private OperandVisitor() {
        }

        @Override
        public QueryOperand visit(Operand.Param param) {
            return new QueryOperand.Param(param.getPropertyMetamodel().asType(), param.createInParameter(NativeSqlUpsertTerminal.this.config));
        }

        @Override
        public QueryOperand visit(Operand.Prop prop) {
            return new QueryOperand.Prop(prop.value.asType());
        }
    }
}

