/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.dialect;

import java.util.List;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.jdbc.dialect.MysqlDialect;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.query.DuplicateKeyType;
import org.seasar.doma.jdbc.query.QueryOperand;
import org.seasar.doma.jdbc.query.QueryOperandPair;
import org.seasar.doma.jdbc.query.UpsertAssembler;
import org.seasar.doma.jdbc.query.UpsertAssemblerContext;
import org.seasar.doma.jdbc.query.UpsertAssemblerSupport;

public class MysqlUpsertAssembler
implements UpsertAssembler {
    private final PreparedSqlBuilder buf;
    private final EntityType<?> entityType;
    private final DuplicateKeyType duplicateKeyType;
    private final UpsertAssemblerSupport upsertAssemblerSupport;
    private final List<QueryOperandPair> insertValues;
    private final List<QueryOperandPair> setValues;
    private final QueryOperand.Visitor queryOperandVisitor = new QueryOperandVisitor();
    private final MysqlDialect.MySqlVersion version;

    public MysqlUpsertAssembler(UpsertAssemblerContext context, MysqlDialect.MySqlVersion version) {
        this.buf = context.buf;
        this.entityType = context.entityType;
        this.duplicateKeyType = context.duplicateKeyType;
        this.insertValues = context.insertValues;
        this.setValues = context.setValues;
        this.version = version;
        this.upsertAssemblerSupport = new UpsertAssemblerSupport(context.naming, context.dialect);
    }

    @Override
    public void assemble() {
        this.buf.appendSql("insert");
        if (this.duplicateKeyType == DuplicateKeyType.IGNORE) {
            this.buf.appendSql(" ignore");
        }
        this.buf.appendSql(" into ");
        this.tableNameOnly(this.entityType);
        this.buf.appendSql(" (");
        for (QueryOperandPair pair : this.insertValues) {
            this.column(pair.getLeft().getEntityPropertyType());
            this.buf.appendSql(", ");
        }
        this.buf.cutBackSql(2);
        this.buf.appendSql(") values (");
        for (QueryOperandPair pair : this.insertValues) {
            pair.getRight().accept(this.queryOperandVisitor);
            this.buf.appendSql(", ");
        }
        this.buf.cutBackSql(2);
        switch (this.version) {
            case V5: {
                this.buf.appendSql(") ");
                break;
            }
            case V8: {
                this.buf.appendSql(") as ");
                this.excludeAlias();
                break;
            }
            default: {
                throw new IllegalStateException(this.version.toString());
            }
        }
        if (this.duplicateKeyType == DuplicateKeyType.UPDATE) {
            this.buf.appendSql(" on duplicate key update ");
            for (QueryOperandPair pair : this.setValues) {
                this.column(pair.getLeft().getEntityPropertyType());
                this.buf.appendSql(" = ");
                pair.getRight().accept(this.queryOperandVisitor);
                this.buf.appendSql(", ");
            }
            this.buf.cutBackSql(2);
        }
    }

    private void tableNameOnly(EntityType<?> entityType) {
        String sql = this.upsertAssemblerSupport.targetTable(entityType, UpsertAssemblerSupport.TableNameType.NAME);
        this.buf.appendSql(sql);
    }

    private void excludeAlias() {
        String sql = this.upsertAssemblerSupport.excludeAlias();
        this.buf.appendSql(sql);
    }

    private void column(EntityPropertyType<?, ?> propertyType) {
        String sql = this.upsertAssemblerSupport.prop(propertyType);
        this.buf.appendSql(sql);
    }

    class QueryOperandVisitor
    implements QueryOperand.Visitor {
        QueryOperandVisitor() {
        }

        @Override
        public void visit(QueryOperand.Param param) {
            MysqlUpsertAssembler.this.buf.appendParameter(param.inParameter);
        }

        @Override
        public void visit(QueryOperand.Prop prop) {
            switch (MysqlUpsertAssembler.this.version) {
                case V5: {
                    String sql = MysqlUpsertAssembler.this.upsertAssemblerSupport.excludeProp(prop.propertyType, UpsertAssemblerSupport.ColumnNameType.NAME);
                    MysqlUpsertAssembler.this.buf.appendSql("values(");
                    MysqlUpsertAssembler.this.buf.appendSql(sql);
                    MysqlUpsertAssembler.this.buf.appendSql(")");
                    break;
                }
                case V8: {
                    String sql = MysqlUpsertAssembler.this.upsertAssemblerSupport.excludeProp(prop.propertyType, UpsertAssemblerSupport.ColumnNameType.NAME_ALIAS);
                    MysqlUpsertAssembler.this.buf.appendSql(sql);
                    break;
                }
                default: {
                    throw new IllegalStateException(MysqlUpsertAssembler.this.version.toString());
                }
            }
        }
    }
}

