/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.dialect;

import java.util.List;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.query.DuplicateKeyType;
import org.seasar.doma.jdbc.query.QueryOperand;
import org.seasar.doma.jdbc.query.QueryOperandPair;
import org.seasar.doma.jdbc.query.UpsertAssembler;
import org.seasar.doma.jdbc.query.UpsertAssemblerContext;
import org.seasar.doma.jdbc.query.UpsertAssemblerSupport;

public class PostgreSqlUpsertAssembler
implements UpsertAssembler {
    private final PreparedSqlBuilder buf;
    private final EntityType<?> entityType;
    private final DuplicateKeyType duplicateKeyType;
    private final UpsertAssemblerSupport upsertAssemblerSupport;
    private final boolean isKeysSpecified;
    private final List<? extends EntityPropertyType<?, ?>> keys;
    private final List<QueryOperandPair> insertValues;
    private final List<QueryOperandPair> setValues;
    private final QueryOperand.Visitor queryOperandVisitor = new QueryOperandVisitor();

    public PostgreSqlUpsertAssembler(UpsertAssemblerContext context) {
        this.buf = context.buf;
        this.entityType = context.entityType;
        this.duplicateKeyType = context.duplicateKeyType;
        this.keys = context.keys;
        this.isKeysSpecified = context.isKeysSpecified;
        this.insertValues = context.insertValues;
        this.setValues = context.setValues;
        this.upsertAssemblerSupport = new UpsertAssemblerSupport(context.naming, context.dialect);
    }

    @Override
    public void assemble() {
        this.buf.appendSql("insert into ");
        this.tableNameAndAlias(this.entityType);
        this.buf.appendSql(" (");
        for (QueryOperandPair queryOperandPair : this.insertValues) {
            this.column(queryOperandPair.getLeft().getEntityPropertyType());
            this.buf.appendSql(", ");
        }
        this.buf.cutBackSql(2);
        this.buf.appendSql(") values (");
        for (QueryOperandPair queryOperandPair : this.insertValues) {
            queryOperandPair.getRight().accept(this.queryOperandVisitor);
            this.buf.appendSql(", ");
        }
        this.buf.cutBackSql(2);
        if (this.duplicateKeyType == DuplicateKeyType.IGNORE) {
            this.buf.appendSql(") on conflict");
            if (this.isKeysSpecified) {
                this.buf.appendSql(" (");
                for (EntityPropertyType entityPropertyType : this.keys) {
                    this.column(entityPropertyType);
                    this.buf.appendSql(", ");
                }
                this.buf.cutBackSql(2);
                this.buf.appendSql(")");
            }
            this.buf.appendSql(" do nothing");
        } else if (this.duplicateKeyType == DuplicateKeyType.UPDATE) {
            this.buf.appendSql(") on conflict (");
            for (EntityPropertyType entityPropertyType : this.keys) {
                this.column(entityPropertyType);
                this.buf.appendSql(", ");
            }
            this.buf.cutBackSql(2);
            this.buf.appendSql(")");
            this.buf.appendSql(" do update set ");
            for (QueryOperandPair queryOperandPair : this.setValues) {
                this.column(queryOperandPair.getLeft().getEntityPropertyType());
                this.buf.appendSql(" = ");
                queryOperandPair.getRight().accept(this.queryOperandVisitor);
                this.buf.appendSql(", ");
            }
            this.buf.cutBackSql(2);
        }
    }

    private void tableNameAndAlias(EntityType<?> entityType) {
        String sql = this.upsertAssemblerSupport.targetTable(entityType, UpsertAssemblerSupport.TableNameType.NAME_AS_ALIAS);
        this.buf.appendSql(sql);
    }

    private void column(EntityPropertyType<?, ?> propertyType) {
        String sql = this.upsertAssemblerSupport.prop(propertyType);
        this.buf.appendSql(sql);
    }

    class QueryOperandVisitor
    implements QueryOperand.Visitor {
        QueryOperandVisitor() {
        }

        @Override
        public void visit(QueryOperand.Param param) {
            PostgreSqlUpsertAssembler.this.buf.appendParameter(param.inParameter);
        }

        @Override
        public void visit(QueryOperand.Prop prop) {
            String sql = PostgreSqlUpsertAssembler.this.upsertAssemblerSupport.excludeProp(prop.propertyType, UpsertAssemblerSupport.ColumnNameType.NAME_ALIAS);
            PostgreSqlUpsertAssembler.this.buf.appendSql(sql);
        }
    }
}

