/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.id;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import org.seasar.doma.GenerationType;
import org.seasar.doma.internal.jdbc.sql.BasicInParameter;
import org.seasar.doma.internal.jdbc.util.JdbcUtil;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.JdbcLogger;
import org.seasar.doma.jdbc.PreparedSql;
import org.seasar.doma.jdbc.RequiresNewController;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.jdbc.id.AbstractPreGenerateIdGenerator;
import org.seasar.doma.jdbc.id.IdGenerationConfig;
import org.seasar.doma.jdbc.id.TableIdGenerator;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;
import org.seasar.doma.wrapper.LongWrapper;
import org.seasar.doma.wrapper.StringWrapper;

public class BuiltinTableIdGenerator
extends AbstractPreGenerateIdGenerator
implements TableIdGenerator {
    protected String qualifiedTableName;
    protected String pkColumnName;
    protected String pkColumnValue;
    protected String valueColumnName;
    protected PreparedSql updateSql;
    protected PreparedSql selectSql;

    @Override
    public void setQualifiedTableName(String qualifiedTableName) {
        this.qualifiedTableName = qualifiedTableName;
    }

    @Override
    public void setPkColumnName(String pkColumnName) {
        this.pkColumnName = pkColumnName;
    }

    @Override
    public void setPkColumnValue(String pkColumnValue) {
        this.pkColumnValue = pkColumnValue;
    }

    @Override
    public void setValueColumnName(String valueColumnName) {
        this.valueColumnName = valueColumnName;
    }

    @Override
    public void initialize() {
        if (this.qualifiedTableName == null) {
            throw new JdbcException((MessageResource)Message.DOMA2033, "qualifiedTableName");
        }
        if (this.pkColumnName == null) {
            throw new JdbcException((MessageResource)Message.DOMA2033, "pkColumnName");
        }
        if (this.pkColumnValue == null) {
            throw new JdbcException((MessageResource)Message.DOMA2033, "pkColumnValue");
        }
        if (this.valueColumnName == null) {
            throw new JdbcException((MessageResource)Message.DOMA2033, "valueColumnName");
        }
        LongWrapper allocationSizeWrapper = new LongWrapper();
        allocationSizeWrapper.set(this.allocationSize);
        StringWrapper pkColumnValueWrapper = new StringWrapper();
        pkColumnValueWrapper.set(this.pkColumnValue);
        this.updateSql = new PreparedSql(SqlKind.UPDATE, this.createUpdateRawSql(), this.createUpdateFormattedSql(), null, Arrays.asList(new BasicInParameter(() -> allocationSizeWrapper), new BasicInParameter(() -> pkColumnValueWrapper)), SqlLogType.FORMATTED);
        this.selectSql = new PreparedSql(SqlKind.SELECT, this.createSelectRawSql(), this.createSelectFormattedSql(), null, Collections.singletonList(new BasicInParameter(() -> pkColumnValueWrapper)), SqlLogType.FORMATTED);
    }

    protected String createUpdateRawSql() {
        return "update " + this.qualifiedTableName + " set " + this.valueColumnName + " = " + this.valueColumnName + " + ? where " + this.pkColumnName + " = ?";
    }

    protected String createUpdateFormattedSql() {
        return "update " + this.qualifiedTableName + " set " + this.valueColumnName + " = " + this.valueColumnName + " + " + this.allocationSize + " where " + this.pkColumnName + " = '" + this.pkColumnValue + "'";
    }

    protected String createSelectRawSql() {
        StringBuilder buf = new StringBuilder(100);
        buf.append("select ");
        buf.append(this.valueColumnName);
        buf.append(" from ");
        buf.append(this.qualifiedTableName);
        buf.append(" where ");
        buf.append(this.pkColumnName);
        buf.append(" = ?");
        return new String(buf);
    }

    protected String createSelectFormattedSql() {
        StringBuilder buf = new StringBuilder(100);
        buf.append("select ");
        buf.append(this.valueColumnName);
        buf.append(" from ");
        buf.append(this.qualifiedTableName);
        buf.append(" where ");
        buf.append(this.pkColumnName);
        buf.append(" = '");
        buf.append(this.pkColumnValue);
        buf.append("'");
        return new String(buf);
    }

    @Override
    protected long getNewInitialValue(IdGenerationConfig config) {
        RequiresNewController controller = config.getRequiresNewController();
        try {
            Long value = controller.requiresNew(() -> {
                this.updateId(config, this.updateSql);
                return this.selectId(config, this.selectSql);
            });
            return value - this.allocationSize;
        }
        catch (Throwable t) {
            throw new JdbcException((MessageResource)Message.DOMA2018, t, config.getEntityType().getName(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateId(IdGenerationConfig config, PreparedSql sql) {
        JdbcLogger logger = config.getJdbcLogger();
        Connection connection = JdbcUtil.getConnection(config.getDataSource());
        try {
            PreparedStatement preparedStatement = JdbcUtil.prepareStatement(connection, sql);
            try {
                logger.logSql(this.getClass().getName(), "updateId", sql);
                this.setupOptions(config, preparedStatement);
                preparedStatement.setLong(1, this.allocationSize);
                preparedStatement.setString(2, this.pkColumnValue);
                int rows = preparedStatement.executeUpdate();
                if (rows != 1) {
                    throw new JdbcException((MessageResource)Message.DOMA2017, config.getEntityType().getName());
                }
            }
            catch (SQLException e) {
                throw new JdbcException((MessageResource)Message.DOMA2018, (Throwable)e, config.getEntityType().getName(), e);
            }
            finally {
                JdbcUtil.close(preparedStatement, logger);
            }
        }
        finally {
            JdbcUtil.close(connection, logger);
        }
    }

    protected long selectId(IdGenerationConfig config, PreparedSql sql) {
        JdbcLogger logger = config.getJdbcLogger();
        Connection connection = JdbcUtil.getConnection(config.getDataSource());
        try {
            PreparedStatement preparedStatement = JdbcUtil.prepareStatement(connection, sql);
            try {
                Object result;
                logger.logSql(this.getClass().getName(), "selectId", sql);
                this.setupOptions(config, preparedStatement);
                preparedStatement.setString(1, this.pkColumnValue);
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next() && (result = resultSet.getObject(1)) instanceof Number) {
                    long l = ((Number)result).longValue();
                    return l;
                }
                try {
                    throw new JdbcException((MessageResource)Message.DOMA2017, config.getEntityType().getName());
                }
                catch (SQLException e) {
                    throw new JdbcException((MessageResource)Message.DOMA2018, (Throwable)e, config.getEntityType().getName(), e);
                }
            }
            finally {
                JdbcUtil.close(preparedStatement, logger);
            }
        }
        finally {
            JdbcUtil.close(connection, logger);
        }
    }

    @Override
    public GenerationType getGenerationType() {
        return GenerationType.TABLE;
    }
}

