/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.query;

import java.lang.reflect.Method;
import java.util.ListIterator;
import org.seasar.doma.internal.jdbc.entity.AbstractPostUpdateContext;
import org.seasar.doma.internal.jdbc.entity.AbstractPreUpdateContext;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.Naming;
import org.seasar.doma.jdbc.PreparedSql;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.Property;
import org.seasar.doma.jdbc.query.AutoBatchModifyQuery;
import org.seasar.doma.jdbc.query.BatchUpdateQuery;
import org.seasar.doma.jdbc.query.BatchUpdateQueryHelper;

public class AutoBatchUpdateQuery<ENTITY>
extends AutoBatchModifyQuery<ENTITY>
implements BatchUpdateQuery {
    protected boolean versionIgnored;
    protected boolean optimisticLockExceptionSuppressed;
    protected BatchUpdateQueryHelper<ENTITY> helper;

    public AutoBatchUpdateQuery(EntityType<ENTITY> entityType) {
        super(entityType);
    }

    @Override
    public void prepare() {
        super.prepare();
        AssertionUtil.assertNotNull((Object)this.method, (Object)this.entities, (Object)this.sqls);
        int size = this.entities.size();
        if (size == 0) {
            return;
        }
        this.currentEntity = this.entities.get(0);
        this.setupHelper();
        this.preUpdate();
        this.prepareIdAndVersionPropertyTypes();
        this.validateIdExistent();
        this.prepareOptions();
        this.prepareOptimisticLock();
        this.prepareTargetPropertyTypes();
        this.prepareSql();
        this.entities.set(0, this.currentEntity);
        ListIterator<Object> it = this.entities.listIterator(1);
        while (it.hasNext()) {
            this.currentEntity = it.next();
            this.preUpdate();
            this.prepareSql();
            it.set(this.currentEntity);
        }
        AssertionUtil.assertEquals(this.entities.size(), this.sqls.size());
    }

    protected void setupHelper() {
        this.helper = new BatchUpdateQueryHelper(this.config, this.entityType, this.includedPropertyNames, this.excludedPropertyNames, this.versionIgnored, this.optimisticLockExceptionSuppressed);
    }

    protected void preUpdate() {
        AutoBatchPreUpdateContext context = new AutoBatchPreUpdateContext(this.entityType, this.method, this.config);
        this.entityType.preUpdate(this.currentEntity, context);
        if (context.getNewEntity() != null) {
            this.currentEntity = context.getNewEntity();
        }
    }

    protected void prepareOptimisticLock() {
        if (this.versionPropertyType != null && !this.versionIgnored && !this.optimisticLockExceptionSuppressed) {
            this.optimisticLockCheckRequired = true;
        }
    }

    protected void prepareTargetPropertyTypes() {
        this.targetPropertyTypes = this.helper.getTargetPropertyTypes();
        if (!this.targetPropertyTypes.isEmpty()) {
            this.executable = true;
            this.sqlExecutionSkipCause = null;
        }
    }

    protected void prepareSql() {
        Property property;
        Naming naming = this.config.getNaming();
        Dialect dialect = this.config.getDialect();
        PreparedSqlBuilder builder = new PreparedSqlBuilder(this.config, SqlKind.BATCH_UPDATE, this.sqlLogType);
        builder.appendSql("update ");
        builder.appendSql(this.entityType.getQualifiedTableName(naming::apply, dialect::applyQuote));
        builder.appendSql(" set ");
        this.helper.populateValues(this.currentEntity, this.targetPropertyTypes, this.versionPropertyType, builder);
        boolean whereClauseAppended = false;
        if (this.idPropertyTypes.size() > 0) {
            builder.appendSql(" where ");
            whereClauseAppended = true;
            for (EntityPropertyType propertyType : this.idPropertyTypes) {
                Property property2 = propertyType.createProperty();
                property2.load(this.currentEntity);
                builder.appendSql(propertyType.getColumnName(naming::apply, dialect::applyQuote));
                builder.appendSql(" = ");
                builder.appendParameter(property2.asInParameter());
                builder.appendSql(" and ");
            }
            builder.cutBackSql(5);
        }
        if (this.versionPropertyType != null && !this.versionIgnored) {
            if (whereClauseAppended) {
                builder.appendSql(" and ");
            } else {
                builder.appendSql(" where ");
                whereClauseAppended = true;
            }
            property = this.versionPropertyType.createProperty();
            property.load(this.currentEntity);
            builder.appendSql(this.versionPropertyType.getColumnName(naming::apply, dialect::applyQuote));
            builder.appendSql(" = ");
            builder.appendParameter(property.asInParameter());
        }
        if (this.tenantIdPropertyType != null) {
            if (whereClauseAppended) {
                builder.appendSql(" and ");
            } else {
                builder.appendSql(" where ");
                whereClauseAppended = true;
            }
            property = this.tenantIdPropertyType.createProperty();
            property.load(this.currentEntity);
            builder.appendSql(this.tenantIdPropertyType.getColumnName(naming::apply, dialect::applyQuote));
            builder.appendSql(" = ");
            builder.appendParameter(property.asInParameter());
        }
        PreparedSql sql = builder.build(this::comment);
        this.sqls.add(sql);
    }

    @Override
    public void incrementVersions() {
        if (this.versionPropertyType != null && !this.versionIgnored) {
            ListIterator it = this.entities.listIterator();
            while (it.hasNext()) {
                Object newEntity = this.versionPropertyType.increment(this.entityType, it.next());
                it.set(newEntity);
            }
        }
    }

    @Override
    public void complete() {
        ListIterator<Object> it = this.entities.listIterator();
        while (it.hasNext()) {
            this.currentEntity = it.next();
            this.postUpdate();
            it.set(this.currentEntity);
        }
    }

    protected void postUpdate() {
        AutoBatchPostUpdateContext context = new AutoBatchPostUpdateContext(this.entityType, this.method, this.config);
        this.entityType.postUpdate(this.currentEntity, context);
        if (context.getNewEntity() != null) {
            this.currentEntity = context.getNewEntity();
        }
        this.entityType.saveCurrentStates(this.currentEntity);
    }

    public void setVersionIgnored(boolean versionIgnored) {
        this.versionIgnored |= versionIgnored;
    }

    public void setOptimisticLockExceptionSuppressed(boolean optimisticLockExceptionSuppressed) {
        this.optimisticLockExceptionSuppressed = optimisticLockExceptionSuppressed;
    }

    protected static class AutoBatchPostUpdateContext<E>
    extends AbstractPostUpdateContext<E> {
        public AutoBatchPostUpdateContext(EntityType<E> entityType, Method method, Config config) {
            super(entityType, method, config);
        }

        @Override
        public boolean isPropertyChanged(String propertyName) {
            this.validatePropertyDefined(propertyName);
            return true;
        }
    }

    protected static class AutoBatchPreUpdateContext<E>
    extends AbstractPreUpdateContext<E> {
        public AutoBatchPreUpdateContext(EntityType<E> entityType, Method method, Config config) {
            super(entityType, method, config);
        }

        @Override
        public boolean isEntityChanged() {
            return true;
        }

        @Override
        public boolean isPropertyChanged(String propertyName) {
            this.validatePropertyDefined(propertyName);
            return true;
        }
    }
}

