/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.query;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.function.Supplier;
import org.seasar.doma.Sql;
import org.seasar.doma.internal.Constants;
import org.seasar.doma.internal.jdbc.util.ScriptFileUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.ScriptFileLoader;
import org.seasar.doma.jdbc.ScriptFileNotFoundException;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.jdbc.query.AbstractQuery;
import org.seasar.doma.jdbc.query.ScriptQuery;

public class SqlFileScriptQuery
extends AbstractQuery
implements ScriptQuery {
    protected String scriptFilePath;
    protected String blockDelimiter;
    protected boolean haltOnError;
    protected URL scriptFileUrl;
    protected Sql sqlAnnotation;
    protected SqlLogType sqlLogType;

    public void setScriptFilePath(String scriptFilePath) {
        this.scriptFilePath = scriptFilePath;
    }

    public void setBlockDelimiter(String blockDelimiter) {
        this.blockDelimiter = blockDelimiter;
    }

    public void setHaltOnError(boolean haltOnError) {
        this.haltOnError = haltOnError;
    }

    public void setSqlLogType(SqlLogType sqlLogType) {
        this.sqlLogType = sqlLogType;
    }

    @Override
    public void prepare() {
        super.prepare();
        AssertionUtil.assertNotNull((Object)this.scriptFilePath, (Object)this.blockDelimiter);
        this.sqlAnnotation = this.method.getAnnotation(Sql.class);
        if (this.sqlAnnotation == null) {
            AssertionUtil.assertTrue(this.scriptFilePath.startsWith("META-INF/"), new Object[0]);
            AssertionUtil.assertTrue(this.scriptFilePath.endsWith(".script"), new Object[0]);
            ScriptFileLoader loader = this.config.getScriptFileLoader();
            String dbmsSpecificPath = ScriptFileUtil.convertToDbmsSpecificPath(this.scriptFilePath, this.config.getDialect());
            this.scriptFileUrl = loader.loadAsURL(dbmsSpecificPath);
            if (this.scriptFileUrl != null) {
                this.scriptFilePath = dbmsSpecificPath;
            } else {
                this.scriptFileUrl = loader.loadAsURL(this.scriptFilePath);
                if (this.scriptFileUrl == null) {
                    throw new ScriptFileNotFoundException(this.scriptFilePath);
                }
            }
        }
        if (this.blockDelimiter.isEmpty()) {
            this.blockDelimiter = this.config.getDialect().getScriptBlockDelimiter();
        }
    }

    @Override
    public void complete() {
    }

    @Override
    public int getQueryTimeout() {
        return -1;
    }

    @Override
    public org.seasar.doma.jdbc.Sql<?> getSql() {
        AssertionUtil.assertUnreachable();
        return null;
    }

    @Override
    public String getScriptFilePath() {
        return this.scriptFilePath;
    }

    @Override
    public URL getScriptFileUrl() {
        return this.scriptFileUrl;
    }

    @Override
    public Supplier<Reader> getReaderSupplier() {
        if (this.sqlAnnotation == null) {
            return () -> {
                try {
                    InputStream inputStream = this.scriptFileUrl.openStream();
                    return new InputStreamReader(inputStream, Constants.UTF_8);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            };
        }
        return () -> new StringReader(this.sqlAnnotation.value());
    }

    @Override
    public String getBlockDelimiter() {
        return this.blockDelimiter;
    }

    @Override
    public boolean getHaltOnError() {
        return this.haltOnError;
    }

    @Override
    public SqlLogType getSqlLogType() {
        return this.sqlLogType;
    }
}

