/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.query;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.seasar.doma.jdbc.InParameter;
import org.seasar.doma.jdbc.Naming;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;

public class UpsertAssemblerSupport {
    private final Naming naming;
    private final Dialect dialect;
    private final UpsertAliasConstants aliasConstants;

    public UpsertAssemblerSupport(Naming naming, Dialect dialect) {
        this(naming, dialect, new DefaultUpsertAliasConstants());
    }

    public UpsertAssemblerSupport(Naming naming, Dialect dialect, UpsertAliasConstants aliasConstants) {
        this.naming = Objects.requireNonNull(naming);
        this.dialect = Objects.requireNonNull(dialect);
        this.aliasConstants = Objects.requireNonNull(aliasConstants);
    }

    public String targetTable(EntityType<?> entityType, TableNameType tableNameType) {
        switch (tableNameType) {
            case NAME: {
                return entityType.getQualifiedTableName(this.naming::apply, this.dialect::applyQuote);
            }
            case ALIAS: {
                return this.aliasConstants.getTargetAlias();
            }
            case AS_ALIAS: {
                return " as " + this.aliasConstants.getTargetAlias();
            }
            case NAME_ALIAS: {
                return entityType.getQualifiedTableName(this.naming::apply, this.dialect::applyQuote) + " " + this.aliasConstants.getTargetAlias();
            }
            case NAME_AS_ALIAS: {
                return entityType.getQualifiedTableName(this.naming::apply, this.dialect::applyQuote) + " as " + this.aliasConstants.getTargetAlias();
            }
        }
        throw new IllegalArgumentException("Unknown table name type: " + (Object)((Object)tableNameType));
    }

    public String targetTable(List<EntityPropertyType<?, ?>> entityPropertyTypes, TableNameType tableNameType) {
        switch (tableNameType) {
            case NAME: 
            case NAME_ALIAS: {
                throw new UnsupportedOperationException();
            }
            case ALIAS: {
                return this.aliasConstants.getTargetAlias();
            }
            case AS_ALIAS: {
                return " as " + this.aliasConstants.getTargetAlias();
            }
        }
        throw new IllegalArgumentException("Unknown table name type: " + (Object)((Object)tableNameType));
    }

    public String targetProp(EntityPropertyType<?, ?> propertyType, ColumnNameType columnNameType) {
        switch (columnNameType) {
            case NAME: {
                return propertyType.getColumnName(this.naming::apply, this.dialect::applyQuote);
            }
            case NAME_ALIAS: {
                return this.aliasConstants.getTargetAlias() + "." + propertyType.getColumnName(this.naming::apply, this.dialect::applyQuote);
            }
        }
        throw new IllegalArgumentException("Unknown table name type: " + (Object)((Object)columnNameType));
    }

    public String excludeAlias() {
        return this.aliasConstants.getExcludedAlias();
    }

    public String excludeProp(EntityPropertyType<?, ?> propertyType, ColumnNameType columnNameType) {
        switch (columnNameType) {
            case NAME: {
                return propertyType.getColumnName(this.naming::apply, this.dialect::applyQuote);
            }
            case NAME_ALIAS: {
                return this.aliasConstants.getExcludedAlias() + "." + propertyType.getColumnName(this.naming::apply, this.dialect::applyQuote);
            }
        }
        throw new IllegalArgumentException("Unknown table name type: " + (Object)((Object)columnNameType));
    }

    public String prop(EntityPropertyType<?, ?> propertyType) {
        return propertyType.getColumnName(this.naming::apply, this.dialect::applyQuote);
    }

    public InParameter<?> param(EntityPropertyType<?, ?> propertyType, Map<EntityPropertyType<?, ?>, InParameter<?>> values) {
        return values.get(propertyType);
    }

    public static interface UpsertAliasConstants {
        public String getTargetAlias();

        public String getExcludedAlias();
    }

    public static class DefaultUpsertAliasConstants
    implements UpsertAliasConstants {
        @Override
        public String getTargetAlias() {
            return "target";
        }

        @Override
        public String getExcludedAlias() {
            return "excluded";
        }
    }

    public static enum ColumnNameType {
        NAME,
        NAME_ALIAS;

    }

    public static enum TableNameType {
        NAME,
        ALIAS,
        AS_ALIAS,
        NAME_ALIAS,
        NAME_AS_ALIAS;

    }
}

