/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.wrapper;

import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.wrapper.DoubleWrapper;
import org.seasar.doma.wrapper.WrapperVisitor;

public class PrimitiveDoubleWrapper
extends DoubleWrapper {
    private static final double defaultValue = 0.0;

    public PrimitiveDoubleWrapper() {
        this(0.0);
    }

    public PrimitiveDoubleWrapper(double value) {
        super(value);
    }

    @Override
    protected void doSet(Double value) {
        this.value = value == null ? 0.0 : value;
    }

    @Override
    public void set(Number v) {
        this.set(v == null ? 0.0 : v.doubleValue());
    }

    @Override
    public Double getDefault() {
        return 0.0;
    }

    @Override
    public boolean isPrimitiveWrapper() {
        return true;
    }

    @Override
    public <R, P, Q, TH extends Throwable> R accept(WrapperVisitor<R, P, Q, TH> visitor, P p, Q q) throws TH {
        if (visitor == null) {
            throw new DomaNullPointerException("visitor");
        }
        return visitor.visitPrimitiveDoubleWrapper(this, p, q);
    }
}

