/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.wrapper;

import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.wrapper.FloatWrapper;
import org.seasar.doma.wrapper.WrapperVisitor;

public class PrimitiveFloatWrapper
extends FloatWrapper {
    private static final float defaultValue = 0.0f;

    public PrimitiveFloatWrapper() {
        this(0.0f);
    }

    public PrimitiveFloatWrapper(float value) {
        super(Float.valueOf(value));
    }

    @Override
    protected void doSet(Float value) {
        this.value = Float.valueOf(value == null ? 0.0f : value.floatValue());
    }

    @Override
    public void set(Number v) {
        this.set(Float.valueOf(v == null ? 0.0f : v.floatValue()));
    }

    @Override
    public Float getDefault() {
        return Float.valueOf(0.0f);
    }

    @Override
    public boolean isPrimitiveWrapper() {
        return true;
    }

    @Override
    public <R, P, Q, TH extends Throwable> R accept(WrapperVisitor<R, P, Q, TH> visitor, P p, Q q) throws TH {
        if (visitor == null) {
            throw new DomaNullPointerException("visitor");
        }
        return visitor.visitPrimitiveFloatWrapper(this, p, q);
    }
}

