/*
 * Copyright Doma Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.seasar.doma.jdbc;

/** Defines the kinds of pessimistic locking. */
public enum SelectForUpdateType {

  /** indicate to get a lock in the normal way */
  NORMAL,

  /** indicates to get a lock without waiting */
  NOWAIT,

  /** indicates to get a lock with waiting */
  WAIT
}
