/*
 * Copyright Doma Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.seasar.doma.jdbc.id;

import java.sql.Connection;
import java.sql.Statement;

/** Defines types for auto generated keys. */
public enum AutoGeneratedKeysType {

  /**
   * Indicates to use the default way.
   *
   * @see Connection#prepareStatement(String, int)
   * @see Statement#RETURN_GENERATED_KEYS
   */
  DEFAULT,

  /**
   * Indicates to specify the first column.
   *
   * @see Connection#prepareStatement(String, int[])
   */
  FIRST_COLUMN
}
