/*
 * Copyright Doma Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.seasar.doma.jdbc.query;

/**
 * An interface for assembling UPDATE queries.
 *
 * <p>This interface is responsible for generating the SQL for UPDATE operations. Implementations of
 * this interface handle the construction of UPDATE statements, including the SET clause, WHERE
 * clause, and any other necessary SQL components.
 */
public interface UpdateAssembler {
  /**
   * Assembles the UPDATE query.
   *
   * <p>This method generates the SQL for the UPDATE operation, including the table name, SET
   * clause, WHERE clause, and any other required SQL components.
   */
  void assemble();
}
