/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal;

import java.util.List;
import java.util.stream.Collectors;
import org.seasar.doma.internal.ClassName;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.internal.util.ClassUtil;

public class ClassNames {
    public static String normalizeBinaryName(CharSequence binaryName) {
        AssertionUtil.assertNotNull(binaryName);
        String name = binaryName.toString();
        String packageName = ClassUtil.getPackageName(name);
        List<String> enclosingNames = ClassUtil.getEnclosingNames(name);
        String simpleName = ClassUtil.getSimpleName(name);
        Object base = "";
        if (packageName.length() > 0) {
            base = packageName + ".";
        }
        return (String)base + enclosingNames.stream().map(n -> n + "__").collect(Collectors.joining()) + simpleName;
    }

    public static ClassName newEntityTypeClassName(CharSequence entityClassName) {
        AssertionUtil.assertNotNull(entityClassName);
        return new ClassNameBuilder(entityClassName).build();
    }

    public static ClassName newEmbeddableTypeClassName(CharSequence embeddedClassName) {
        AssertionUtil.assertNotNull(embeddedClassName);
        return new ClassNameBuilder(embeddedClassName).build();
    }

    public static ClassName newDomainTypeClassName(CharSequence domainClassName) {
        AssertionUtil.assertNotNull(domainClassName);
        return new ClassNameBuilder(domainClassName).build();
    }

    public static ClassName newExternalDomainTypeClassName(CharSequence externalDomainClassName) {
        AssertionUtil.assertNotNull(externalDomainClassName);
        return new ExternalDomainClassNameBuilder(externalDomainClassName).build();
    }

    public static ClassName newEntityMetamodelClassNameBuilder(CharSequence entityClassName, String metamodelPrefix, String metamodelSuffix) {
        AssertionUtil.assertNotNull((Object)entityClassName, (Object)metamodelPrefix, (Object)metamodelSuffix);
        return new MetamodelClassNameBuilder(entityClassName, metamodelPrefix, metamodelSuffix).build();
    }

    public static ClassName newAggregateStrategyTypeClassName(CharSequence aggregateStrategyClassName) {
        AssertionUtil.assertNotNull(aggregateStrategyClassName);
        return new ClassNameBuilder(aggregateStrategyClassName).build();
    }

    private static class ClassNameBuilder {
        final String binaryName;

        private ClassNameBuilder(CharSequence binaryName) {
            this.binaryName = binaryName.toString();
        }

        protected String prefix() {
            String packageName = ClassUtil.getPackageName(this.binaryName);
            Object prefix = "";
            if (packageName.length() > 0) {
                prefix = packageName + ".";
            }
            return prefix;
        }

        protected String infix() {
            return "_";
        }

        protected String suffix() {
            String normalizeBinaryName = ClassNames.normalizeBinaryName(this.binaryName);
            return ClassUtil.getSimpleName(normalizeBinaryName);
        }

        public ClassName build() {
            return new ClassName(this.prefix() + this.infix() + this.suffix());
        }
    }

    private static class ExternalDomainClassNameBuilder
    extends ClassNameBuilder {
        private ExternalDomainClassNameBuilder(CharSequence binaryName) {
            super(binaryName);
        }

        @Override
        protected String prefix() {
            return "__." + ClassUtil.getPackageName(this.binaryName) + ".";
        }
    }

    private static class MetamodelClassNameBuilder
    extends ClassNameBuilder {
        private final String criteriaPrefix;
        private final String criteriaSuffix;

        public MetamodelClassNameBuilder(CharSequence binaryName, String criteriaPrefix, String criteriaSuffix) {
            super(binaryName);
            this.criteriaPrefix = criteriaPrefix;
            this.criteriaSuffix = criteriaSuffix;
        }

        @Override
        protected String infix() {
            return this.criteriaPrefix;
        }

        @Override
        protected String suffix() {
            return super.suffix() + this.criteriaSuffix;
        }
    }
}

