/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.expr;

import java.nio.CharBuffer;
import org.seasar.doma.internal.expr.ExpressionException;
import org.seasar.doma.internal.expr.ExpressionTokenType;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;

public class ClassicExpressionTokenizer {
    protected final String expression;
    protected final CharBuffer buf;
    protected final CharBuffer duplicatedBuf;
    protected ExpressionTokenType type;
    protected String token;
    protected int position;
    protected boolean binaryOpAvailable;

    public ClassicExpressionTokenizer(String expression) {
        AssertionUtil.assertNotNull(expression);
        this.expression = expression;
        this.buf = CharBuffer.wrap(expression);
        this.duplicatedBuf = this.buf.duplicate();
        this.peek();
    }

    public ExpressionTokenType next() {
        if (this.type == ExpressionTokenType.EOE) {
            this.token = null;
            return ExpressionTokenType.EOE;
        }
        ExpressionTokenType currentType = this.type;
        this.prepareToken();
        this.peek();
        return currentType;
    }

    protected void prepareToken() {
        this.position = this.buf.position();
        this.duplicatedBuf.limit(this.position);
        this.token = this.duplicatedBuf.toString();
        this.duplicatedBuf.position(this.position);
    }

    public String getToken() {
        return this.token;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position, boolean binaryOpAvailable) {
        this.position = position;
        this.binaryOpAvailable = binaryOpAvailable;
        this.duplicatedBuf.limit(position);
        this.duplicatedBuf.position(position);
        this.buf.position(position);
        this.peek();
    }

    protected void peek() {
        if (this.buf.hasRemaining()) {
            char c = this.buf.get();
            if (this.buf.hasRemaining()) {
                char c2 = this.buf.get();
                if (this.buf.hasRemaining()) {
                    char c3 = this.buf.get();
                    if (this.buf.hasRemaining()) {
                        char c4 = this.buf.get();
                        if (this.buf.hasRemaining()) {
                            char c5 = this.buf.get();
                            this.peekFiveChars(c, c2, c3, c4, c5);
                        } else {
                            this.peekFourChars(c, c2, c3, c4);
                        }
                    } else {
                        this.peekThreeChars(c, c2, c3);
                    }
                } else {
                    this.peekTwoChars(c, c2);
                }
            } else {
                this.peekOneChar(c);
            }
        } else {
            this.type = ExpressionTokenType.EOE;
        }
    }

    protected void peekFiveChars(char c, char c2, char c3, char c4, char c5) {
        if (c == 'f' && c2 == 'a' && c3 == 'l' && c4 == 's' && c5 == 'e' && this.isWordTerminated()) {
            this.type = ExpressionTokenType.FALSE_LITERAL;
            this.binaryOpAvailable = true;
            return;
        }
        this.buf.position(this.buf.position() - 1);
        this.peekFourChars(c, c2, c3, c4);
    }

    protected void peekFourChars(char c, char c2, char c3, char c4) {
        if (c == 'n' && c2 == 'u' && c3 == 'l' && c4 == 'l') {
            if (this.isWordTerminated()) {
                this.type = ExpressionTokenType.NULL_LITERAL;
                this.binaryOpAvailable = true;
                return;
            }
        } else if (c == 't' && c2 == 'r' && c3 == 'u' && c4 == 'e' && this.isWordTerminated()) {
            this.type = ExpressionTokenType.TRUE_LITERAL;
            this.binaryOpAvailable = true;
            return;
        }
        this.buf.position(this.buf.position() - 1);
        this.peekThreeChars(c, c2, c3);
    }

    protected void peekThreeChars(char c, char c2, char c3) {
        if (c == 'n' && c2 == 'e' && c3 == 'w' && this.isWordTerminated()) {
            this.type = ExpressionTokenType.NEW_OPERATOR;
            return;
        }
        this.buf.position(this.buf.position() - 1);
        this.peekTwoChars(c, c2);
    }

    protected void peekTwoChars(char c, char c2) {
        if (this.binaryOpAvailable) {
            if (c == '&' && c2 == '&') {
                this.type = ExpressionTokenType.AND_OPERATOR;
                this.binaryOpAvailable = false;
                return;
            }
            if (c == '|' && c2 == '|') {
                this.type = ExpressionTokenType.OR_OPERATOR;
                this.binaryOpAvailable = false;
                return;
            }
            if (c == '=' && c2 == '=') {
                this.type = ExpressionTokenType.EQ_OPERATOR;
                this.binaryOpAvailable = false;
                return;
            }
            if (c == '!' && c2 == '=') {
                this.type = ExpressionTokenType.NE_OPERATOR;
                this.binaryOpAvailable = false;
                return;
            }
            if (c == '>' && c2 == '=') {
                this.type = ExpressionTokenType.GE_OPERATOR;
                this.binaryOpAvailable = false;
                return;
            }
            if (c == '<' && c2 == '=') {
                this.type = ExpressionTokenType.LE_OPERATOR;
                this.binaryOpAvailable = false;
                return;
            }
        }
        this.buf.position(this.buf.position() - 1);
        this.peekOneChar(c);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void peekOneChar(char c) {
        if (this.binaryOpAvailable) {
            if (c == '>') {
                this.type = ExpressionTokenType.GT_OPERATOR;
                this.binaryOpAvailable = false;
                return;
            }
            if (c == '<') {
                this.type = ExpressionTokenType.LT_OPERATOR;
                this.binaryOpAvailable = false;
                return;
            }
            if (c == '+') {
                this.type = ExpressionTokenType.ADD_OPERATOR;
                this.binaryOpAvailable = false;
                return;
            }
            if (c == '-') {
                this.type = ExpressionTokenType.SUBTRACT_OPERATOR;
                this.binaryOpAvailable = false;
                return;
            }
            if (c == '*') {
                this.type = ExpressionTokenType.MULTIPLY_OPERATOR;
                this.binaryOpAvailable = false;
                return;
            }
            if (c == '/') {
                this.type = ExpressionTokenType.DIVIDE_OPERATOR;
                this.binaryOpAvailable = false;
                return;
            }
            if (c == '%') {
                this.type = ExpressionTokenType.MOD_OPERATOR;
                this.binaryOpAvailable = false;
                return;
            }
        }
        if (Character.isWhitespace(c)) {
            this.type = ExpressionTokenType.WHITESPACE;
            return;
        }
        if (c == ',') {
            this.type = ExpressionTokenType.COMMA_OPERATOR;
            return;
        }
        if (c == '(') {
            this.type = ExpressionTokenType.OPENED_PARENS;
            return;
        }
        if (c == ')') {
            this.type = ExpressionTokenType.CLOSED_PARENS;
            this.binaryOpAvailable = true;
            return;
        }
        if (c == '!') {
            this.type = ExpressionTokenType.NOT_OPERATOR;
            return;
        }
        if (c == '\'') {
            char c3;
            this.type = ExpressionTokenType.CHAR_LITERAL;
            if (!this.buf.hasRemaining()) throw new ExpressionException(Message.DOMA3016, this.expression, this.buf.position());
            this.buf.get();
            if (!this.buf.hasRemaining() || (c3 = this.buf.get()) != '\'') throw new ExpressionException(Message.DOMA3016, this.expression, this.buf.position());
            this.binaryOpAvailable = true;
            return;
        }
        if (c == '\"') {
            this.type = ExpressionTokenType.STRING_LITERAL;
            boolean closed = false;
            while (this.buf.hasRemaining()) {
                char c2 = this.buf.get();
                if (c2 != '\"') continue;
                if (this.buf.hasRemaining()) {
                    this.buf.mark();
                    char c3 = this.buf.get();
                    if (c3 == '\"') continue;
                    this.buf.reset();
                    closed = true;
                    break;
                }
                closed = true;
            }
            if (!closed) {
                throw new ExpressionException(Message.DOMA3004, this.expression, this.buf.position());
            }
            this.binaryOpAvailable = true;
            return;
        }
        if (c == '+' || c == '-') {
            this.buf.mark();
            if (this.buf.hasRemaining()) {
                char c2 = this.buf.get();
                if (Character.isDigit(c2)) {
                    this.peekNumber();
                    return;
                }
                this.buf.reset();
            }
            this.type = ExpressionTokenType.ILLEGAL_NUMBER_LITERAL;
            return;
        }
        if (Character.isDigit(c)) {
            this.peekNumber();
            return;
        }
        if (Character.isJavaIdentifierStart(c)) {
            this.type = ExpressionTokenType.VARIABLE;
            this.binaryOpAvailable = true;
            while (this.buf.hasRemaining()) {
                this.buf.mark();
                char c2 = this.buf.get();
                if (Character.isJavaIdentifierPart(c2)) continue;
                this.buf.reset();
                return;
            }
            return;
        }
        if (c == '.') {
            this.type = ExpressionTokenType.FIELD_OPERATOR;
            this.binaryOpAvailable = true;
            if (!this.buf.hasRemaining()) {
                throw new ExpressionException(Message.DOMA3021, this.expression, this.buf.position());
            }
            this.buf.mark();
            char c2 = this.buf.get();
            if (!Character.isJavaIdentifierStart(c2)) throw new ExpressionException(Message.DOMA3022, this.expression, this.buf.position(), Character.valueOf(c2));
            while (this.buf.hasRemaining()) {
                this.buf.mark();
                char c3 = this.buf.get();
                if (Character.isJavaIdentifierPart(c3)) continue;
                if (c3 == '(') {
                    this.type = ExpressionTokenType.METHOD_OPERATOR;
                    this.binaryOpAvailable = false;
                }
                this.buf.reset();
                return;
            }
            return;
        } else if (c == '@') {
            if (!this.buf.hasRemaining()) {
                throw new ExpressionException(Message.DOMA3023, this.expression, this.buf.position());
            }
            this.buf.mark();
            char c2 = this.buf.get();
            if (!Character.isJavaIdentifierStart(c2)) throw new ExpressionException(Message.DOMA3024, this.expression, this.buf.position(), Character.valueOf(c2));
            while (this.buf.hasRemaining()) {
                this.buf.mark();
                char c3 = this.buf.get();
                if (Character.isJavaIdentifierPart(c3)) continue;
                if (c3 == '(') {
                    this.type = ExpressionTokenType.FUNCTION_OPERATOR;
                    this.binaryOpAvailable = false;
                    this.buf.reset();
                    return;
                }
                if (c3 == '@') {
                    this.peekStaticMember();
                    return;
                }
                if (c3 != '.') throw new ExpressionException(Message.DOMA3025, this.expression, this.buf.position());
                while (this.buf.hasRemaining()) {
                    this.buf.mark();
                    char c4 = this.buf.get();
                    if (Character.isJavaIdentifierPart(c4) || c4 == '.') continue;
                    if (c4 != '@') throw new ExpressionException(Message.DOMA3031, this.expression, this.buf.position(), Character.valueOf(c4));
                    this.peekStaticMember();
                    return;
                }
                throw new ExpressionException(Message.DOMA3032, this.expression, this.buf.position());
            }
            return;
        } else {
            this.type = ExpressionTokenType.OTHER;
        }
    }

    protected void peekStaticMember() {
        this.type = ExpressionTokenType.STATIC_FIELD_OPERATOR;
        this.binaryOpAvailable = true;
        if (!this.buf.hasRemaining()) {
            throw new ExpressionException(Message.DOMA3029, this.expression, this.buf.position());
        }
        this.buf.mark();
        char c = this.buf.get();
        if (Character.isJavaIdentifierStart(c)) {
            while (this.buf.hasRemaining()) {
                this.buf.mark();
                char c2 = this.buf.get();
                if (Character.isJavaIdentifierPart(c2)) continue;
                if (c2 == '(') {
                    this.type = ExpressionTokenType.STATIC_METHOD_OPERATOR;
                    this.binaryOpAvailable = false;
                }
                this.buf.reset();
                return;
            }
        } else {
            throw new ExpressionException(Message.DOMA3030, this.expression, this.buf.position(), Character.valueOf(c));
        }
    }

    protected void peekNumber() {
        this.type = ExpressionTokenType.INT_LITERAL;
        boolean decimal = false;
        while (this.buf.hasRemaining()) {
            this.buf.mark();
            char c2 = this.buf.get();
            if (Character.isDigit(c2)) continue;
            if (c2 == '.') {
                if (decimal) {
                    this.type = ExpressionTokenType.ILLEGAL_NUMBER_LITERAL;
                    return;
                }
                decimal = true;
                if (this.buf.hasRemaining()) {
                    char c3 = this.buf.get();
                    if (Character.isDigit(c3)) continue;
                    this.type = ExpressionTokenType.ILLEGAL_NUMBER_LITERAL;
                    return;
                }
                this.type = ExpressionTokenType.ILLEGAL_NUMBER_LITERAL;
                return;
            }
            if (c2 == 'F') {
                this.type = ExpressionTokenType.FLOAT_LITERAL;
                break;
            }
            if (c2 == 'D') {
                this.type = ExpressionTokenType.DOUBLE_LITERAL;
                break;
            }
            if (c2 == 'L') {
                this.type = ExpressionTokenType.LONG_LITERAL;
                break;
            }
            if (c2 == 'B') {
                this.type = ExpressionTokenType.BIGDECIMAL_LITERAL;
                break;
            }
            this.buf.reset();
            break;
        }
        if (!this.isWordTerminated()) {
            this.type = ExpressionTokenType.ILLEGAL_NUMBER_LITERAL;
        }
        if ((this.type == ExpressionTokenType.INT_LITERAL || this.type == ExpressionTokenType.LONG_LITERAL) && decimal) {
            this.type = ExpressionTokenType.ILLEGAL_NUMBER_LITERAL;
        }
        this.binaryOpAvailable = true;
    }

    protected boolean isWordTerminated() {
        this.buf.mark();
        if (this.buf.hasRemaining()) {
            char c = this.buf.get();
            if (!Character.isJavaIdentifierPart(c)) {
                this.buf.reset();
                return true;
            }
        } else {
            return true;
        }
        return false;
    }
}

