/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.expr;

import java.nio.CharBuffer;
import org.seasar.doma.internal.expr.ExpressionException;
import org.seasar.doma.internal.expr.ExpressionTokenType;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;

public class ExpressionTokenizer {
    private final String expression;
    private final CharBuffer buf;
    private ExpressionTokenType type;
    private String token;
    private int position;
    private int tokenStartIndex;
    private boolean binaryOpAvailable;

    public ExpressionTokenizer(String expression) {
        AssertionUtil.assertNotNull(expression);
        this.expression = expression;
        this.buf = CharBuffer.wrap(expression);
        this.peek();
    }

    public ExpressionTokenType next() {
        if (this.type == ExpressionTokenType.EOE) {
            this.token = null;
            return ExpressionTokenType.EOE;
        }
        ExpressionTokenType currentType = this.type;
        this.prepareToken();
        this.peek();
        return currentType;
    }

    private void prepareToken() {
        this.position = this.buf.position();
        this.token = this.expression.substring(this.tokenStartIndex, this.position);
        this.tokenStartIndex = this.position;
    }

    public String getToken() {
        return this.token;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position, boolean binaryOpAvailable) {
        this.position = position;
        this.binaryOpAvailable = binaryOpAvailable;
        this.buf.position(position);
        this.tokenStartIndex = position;
        this.peek();
    }

    private void peek() {
        if (!this.buf.hasRemaining()) {
            this.type = ExpressionTokenType.EOE;
            return;
        }
        char c1 = this.buf.get();
        if (!this.buf.hasRemaining()) {
            this.peekOneChar(c1);
            return;
        }
        if (Character.isJavaIdentifierStart(c1) && c1 != 'f' && c1 != 't' && c1 != 'n') {
            this.handleVariable();
            return;
        }
        char c2 = this.buf.get();
        if (!this.buf.hasRemaining()) {
            this.peekTwoChars(c1, c2);
            return;
        }
        if (!Character.isJavaIdentifierStart(c1)) {
            if (!Character.isJavaIdentifierStart(c1)) {
                this.peekTwoChars(c1, c2);
            } else {
                this.buf.position(this.buf.position() - 1);
                this.peekOneChar(c1);
            }
            return;
        }
        char c3 = this.buf.get();
        if (this.isNewOperator(c1, c2, c3)) {
            this.type = ExpressionTokenType.NEW_OPERATOR;
            return;
        }
        if (!this.buf.hasRemaining()) {
            this.buf.position(this.buf.position() - 2);
            this.handleVariable();
            return;
        }
        char c4 = this.buf.get();
        if (this.isNullLiteral(c1, c2, c3, c4)) {
            this.type = ExpressionTokenType.NULL_LITERAL;
            this.binaryOpAvailable = true;
            return;
        }
        if (this.isTrueLiteral(c1, c2, c3, c4)) {
            this.type = ExpressionTokenType.TRUE_LITERAL;
            this.binaryOpAvailable = true;
            return;
        }
        if (!this.buf.hasRemaining()) {
            this.buf.position(this.buf.position() - 3);
            this.handleVariable();
            return;
        }
        char c5 = this.buf.get();
        if (this.isFalseLiteral(c1, c2, c3, c4, c5)) {
            this.type = ExpressionTokenType.FALSE_LITERAL;
            this.binaryOpAvailable = true;
            return;
        }
        this.buf.position(this.buf.position() - 4);
        this.handleVariable();
    }

    private boolean isNewOperator(char c1, char c2, char c3) {
        return c1 == 'n' && c2 == 'e' && c3 == 'w' && this.isWordTerminated();
    }

    private boolean isNullLiteral(char c1, char c2, char c3, char c4) {
        return c1 == 'n' && c2 == 'u' && c3 == 'l' && c4 == 'l' && this.isWordTerminated();
    }

    private boolean isTrueLiteral(char c1, char c2, char c3, char c4) {
        return c1 == 't' && c2 == 'r' && c3 == 'u' && c4 == 'e' && this.isWordTerminated();
    }

    private boolean isFalseLiteral(char c1, char c2, char c3, char c4, char c5) {
        return c1 == 'f' && c2 == 'a' && c3 == 'l' && c4 == 's' && c5 == 'e' && this.isWordTerminated();
    }

    private void peekTwoChars(char c1, char c2) {
        if (this.binaryOpAvailable) {
            if (c1 == '&' && c2 == '&') {
                this.type = ExpressionTokenType.AND_OPERATOR;
                this.binaryOpAvailable = false;
                return;
            }
            if (c1 == '|' && c2 == '|') {
                this.type = ExpressionTokenType.OR_OPERATOR;
                this.binaryOpAvailable = false;
                return;
            }
            if (c1 == '=' && c2 == '=') {
                this.type = ExpressionTokenType.EQ_OPERATOR;
                this.binaryOpAvailable = false;
                return;
            }
            if (c1 == '!' && c2 == '=') {
                this.type = ExpressionTokenType.NE_OPERATOR;
                this.binaryOpAvailable = false;
                return;
            }
            if (c1 == '>' && c2 == '=') {
                this.type = ExpressionTokenType.GE_OPERATOR;
                this.binaryOpAvailable = false;
                return;
            }
            if (c1 == '<' && c2 == '=') {
                this.type = ExpressionTokenType.LE_OPERATOR;
                this.binaryOpAvailable = false;
                return;
            }
        }
        this.buf.position(this.buf.position() - 1);
        this.peekOneChar(c1);
    }

    private void peekOneChar(char c) {
        if (this.binaryOpAvailable) {
            switch (c) {
                case '>': {
                    this.type = ExpressionTokenType.GT_OPERATOR;
                    this.binaryOpAvailable = false;
                    return;
                }
                case '<': {
                    this.type = ExpressionTokenType.LT_OPERATOR;
                    this.binaryOpAvailable = false;
                    return;
                }
                case '+': {
                    this.type = ExpressionTokenType.ADD_OPERATOR;
                    this.binaryOpAvailable = false;
                    return;
                }
                case '-': {
                    this.type = ExpressionTokenType.SUBTRACT_OPERATOR;
                    this.binaryOpAvailable = false;
                    return;
                }
                case '*': {
                    this.type = ExpressionTokenType.MULTIPLY_OPERATOR;
                    this.binaryOpAvailable = false;
                    return;
                }
                case '/': {
                    this.type = ExpressionTokenType.DIVIDE_OPERATOR;
                    this.binaryOpAvailable = false;
                    return;
                }
                case '%': {
                    this.type = ExpressionTokenType.MOD_OPERATOR;
                    this.binaryOpAvailable = false;
                    return;
                }
            }
        }
        switch (c) {
            case '\t': 
            case '\n': 
            case '\u000b': 
            case '\f': 
            case '\r': 
            case '\u001c': 
            case '\u001d': 
            case '\u001e': 
            case '\u001f': 
            case ' ': {
                this.type = ExpressionTokenType.WHITESPACE;
                return;
            }
            case ',': {
                this.type = ExpressionTokenType.COMMA_OPERATOR;
                return;
            }
            case '(': {
                this.type = ExpressionTokenType.OPENED_PARENS;
                return;
            }
            case ')': {
                this.type = ExpressionTokenType.CLOSED_PARENS;
                this.binaryOpAvailable = true;
                return;
            }
            case '!': {
                this.type = ExpressionTokenType.NOT_OPERATOR;
                return;
            }
            case '\'': {
                this.handleCharLiteral();
                return;
            }
            case '\"': {
                this.handleStringLiteral();
                return;
            }
            case '+': 
            case '-': {
                this.handleSignedNumber();
                return;
            }
            case '.': {
                this.handleFieldOrMethodOperator();
                return;
            }
            case '@': {
                this.handleFunctionOperator();
                return;
            }
        }
        if (Character.isWhitespace(c)) {
            this.type = ExpressionTokenType.WHITESPACE;
        } else if (Character.isDigit(c)) {
            this.peekNumber();
        } else if (Character.isJavaIdentifierStart(c)) {
            this.handleVariable();
        } else {
            this.type = ExpressionTokenType.OTHER;
        }
    }

    private void handleCharLiteral() {
        this.type = ExpressionTokenType.CHAR_LITERAL;
        if (this.buf.hasRemaining()) {
            char c;
            this.buf.get();
            if (this.buf.hasRemaining() && (c = this.buf.get()) == '\'') {
                this.binaryOpAvailable = true;
                return;
            }
        }
        throw new ExpressionException(Message.DOMA3016, this.expression, this.buf.position());
    }

    private void handleStringLiteral() {
        this.type = ExpressionTokenType.STRING_LITERAL;
        boolean closed = false;
        while (this.buf.hasRemaining()) {
            char c1 = this.buf.get();
            if (c1 != '\"') continue;
            if (this.buf.hasRemaining()) {
                this.buf.mark();
                char c2 = this.buf.get();
                if (c2 == '\"') continue;
                this.buf.reset();
                closed = true;
                break;
            }
            closed = true;
        }
        if (!closed) {
            throw new ExpressionException(Message.DOMA3004, this.expression, this.buf.position());
        }
        this.binaryOpAvailable = true;
    }

    private void handleSignedNumber() {
        this.buf.mark();
        if (this.buf.hasRemaining()) {
            char c = this.buf.get();
            if (Character.isDigit(c)) {
                this.peekNumber();
                return;
            }
            this.buf.reset();
        }
        this.type = ExpressionTokenType.ILLEGAL_NUMBER_LITERAL;
    }

    private void handleVariable() {
        this.type = ExpressionTokenType.VARIABLE;
        this.binaryOpAvailable = true;
        while (this.buf.hasRemaining()) {
            this.buf.mark();
            char c = this.buf.get();
            if (Character.isJavaIdentifierPart(c)) continue;
            this.buf.reset();
            break;
        }
    }

    private void handleFieldOrMethodOperator() {
        this.type = ExpressionTokenType.FIELD_OPERATOR;
        this.binaryOpAvailable = true;
        if (!this.buf.hasRemaining()) {
            throw new ExpressionException(Message.DOMA3021, this.expression, this.buf.position());
        }
        this.buf.mark();
        char c1 = this.buf.get();
        if (Character.isJavaIdentifierStart(c1)) {
            while (this.buf.hasRemaining()) {
                this.buf.mark();
                char c2 = this.buf.get();
                if (Character.isJavaIdentifierPart(c2)) continue;
                if (c2 == '(') {
                    this.type = ExpressionTokenType.METHOD_OPERATOR;
                    this.binaryOpAvailable = false;
                }
                this.buf.reset();
                return;
            }
        } else {
            throw new ExpressionException(Message.DOMA3022, this.expression, this.buf.position(), Character.valueOf(c1));
        }
    }

    private void handleFunctionOperator() {
        if (!this.buf.hasRemaining()) {
            throw new ExpressionException(Message.DOMA3023, this.expression, this.buf.position());
        }
        this.buf.mark();
        char c1 = this.buf.get();
        if (Character.isJavaIdentifierStart(c1)) {
            while (this.buf.hasRemaining()) {
                this.buf.mark();
                char c2 = this.buf.get();
                if (Character.isJavaIdentifierPart(c2)) continue;
                if (c2 == '(') {
                    this.type = ExpressionTokenType.FUNCTION_OPERATOR;
                    this.binaryOpAvailable = false;
                    this.buf.reset();
                    return;
                }
                if (c2 == '@') {
                    this.peekStaticMember();
                    return;
                }
                if (c2 == '.') {
                    while (this.buf.hasRemaining()) {
                        this.buf.mark();
                        char c3 = this.buf.get();
                        if (Character.isJavaIdentifierPart(c3) || c3 == '.') continue;
                        if (c3 == '@') {
                            this.peekStaticMember();
                            return;
                        }
                        throw new ExpressionException(Message.DOMA3031, this.expression, this.buf.position(), Character.valueOf(c3));
                    }
                    throw new ExpressionException(Message.DOMA3032, this.expression, this.buf.position());
                }
                throw new ExpressionException(Message.DOMA3025, this.expression, this.buf.position());
            }
        } else {
            throw new ExpressionException(Message.DOMA3024, this.expression, this.buf.position(), Character.valueOf(c1));
        }
    }

    private void peekStaticMember() {
        this.type = ExpressionTokenType.STATIC_FIELD_OPERATOR;
        this.binaryOpAvailable = true;
        if (!this.buf.hasRemaining()) {
            throw new ExpressionException(Message.DOMA3029, this.expression, this.buf.position());
        }
        this.buf.mark();
        char c1 = this.buf.get();
        if (Character.isJavaIdentifierStart(c1)) {
            while (this.buf.hasRemaining()) {
                this.buf.mark();
                char c2 = this.buf.get();
                if (Character.isJavaIdentifierPart(c2)) continue;
                if (c2 == '(') {
                    this.type = ExpressionTokenType.STATIC_METHOD_OPERATOR;
                    this.binaryOpAvailable = false;
                }
                this.buf.reset();
                return;
            }
        } else {
            throw new ExpressionException(Message.DOMA3030, this.expression, this.buf.position(), Character.valueOf(c1));
        }
    }

    private void peekNumber() {
        this.type = ExpressionTokenType.INT_LITERAL;
        boolean decimal = false;
        while (this.buf.hasRemaining()) {
            this.buf.mark();
            char c1 = this.buf.get();
            if (Character.isDigit(c1)) continue;
            if (c1 == '.') {
                if (decimal) {
                    this.type = ExpressionTokenType.ILLEGAL_NUMBER_LITERAL;
                    return;
                }
                decimal = true;
                if (this.buf.hasRemaining()) {
                    char c2 = this.buf.get();
                    if (Character.isDigit(c2)) continue;
                    this.type = ExpressionTokenType.ILLEGAL_NUMBER_LITERAL;
                    return;
                }
                this.type = ExpressionTokenType.ILLEGAL_NUMBER_LITERAL;
                return;
            }
            if (c1 == 'F') {
                this.type = ExpressionTokenType.FLOAT_LITERAL;
                break;
            }
            if (c1 == 'D') {
                this.type = ExpressionTokenType.DOUBLE_LITERAL;
                break;
            }
            if (c1 == 'L') {
                this.type = ExpressionTokenType.LONG_LITERAL;
                break;
            }
            if (c1 == 'B') {
                this.type = ExpressionTokenType.BIGDECIMAL_LITERAL;
                break;
            }
            this.buf.reset();
            break;
        }
        if (!this.isWordTerminated()) {
            this.type = ExpressionTokenType.ILLEGAL_NUMBER_LITERAL;
        }
        if ((this.type == ExpressionTokenType.INT_LITERAL || this.type == ExpressionTokenType.LONG_LITERAL) && decimal) {
            this.type = ExpressionTokenType.ILLEGAL_NUMBER_LITERAL;
        }
        this.binaryOpAvailable = true;
    }

    private boolean isWordTerminated() {
        this.buf.mark();
        if (this.buf.hasRemaining()) {
            char c = this.buf.get();
            if (!Character.isJavaIdentifierPart(c)) {
                this.buf.reset();
                return true;
            }
        } else {
            return true;
        }
        return false;
    }
}

