/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.expr.node;

import org.seasar.doma.internal.expr.node.ExpressionLocation;
import org.seasar.doma.internal.expr.node.ExpressionNode;
import org.seasar.doma.internal.expr.node.ExpressionNodeVisitor;
import org.seasar.doma.internal.expr.node.OperatorNode;
import org.seasar.doma.internal.util.AssertionUtil;

public class FieldOperatorNode
implements OperatorNode {
    protected static final int PRIORITY = 0;
    protected final ExpressionLocation location;
    protected final String expression;
    protected final String fieldName;
    protected ExpressionNode targetObjectNode;

    @Override
    public int getPriority() {
        return 0;
    }

    public FieldOperatorNode(ExpressionLocation location, String expression, String fieldName) {
        AssertionUtil.assertNotNull((Object)location, (Object)fieldName);
        this.location = location;
        this.expression = expression;
        this.fieldName = fieldName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public ExpressionNode getTargetObjectNode() {
        return this.targetObjectNode;
    }

    public void setTargetObjectNode(ExpressionNode targetObjectNode) {
        this.targetObjectNode = targetObjectNode;
    }

    @Override
    public <R, P> R accept(ExpressionNodeVisitor<R, P> visitor, P p) {
        return visitor.visitFieldOperatorNode(this, p);
    }

    @Override
    public ExpressionLocation getLocation() {
        return this.location;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    public String toString() {
        return String.valueOf(this.targetObjectNode) + this.expression;
    }
}

