/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.expr.node;

import org.seasar.doma.internal.expr.node.ExpressionLocation;
import org.seasar.doma.internal.expr.node.ExpressionNode;
import org.seasar.doma.internal.expr.node.ExpressionNodeVisitor;
import org.seasar.doma.internal.expr.node.OperatorNode;
import org.seasar.doma.internal.util.AssertionUtil;

public class FunctionOperatorNode
implements OperatorNode {
    protected static final int PRIORITY = 0;
    protected final ExpressionLocation location;
    protected final String expression;
    protected final String methodName;
    protected ExpressionNode parametersNode;

    @Override
    public int getPriority() {
        return 0;
    }

    public FunctionOperatorNode(ExpressionLocation location, String expression, String methodName) {
        AssertionUtil.assertNotNull((Object)location, (Object)methodName);
        this.location = location;
        this.expression = expression;
        this.methodName = methodName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public ExpressionNode getParametersNode() {
        return this.parametersNode;
    }

    public void setParametersNode(ExpressionNode parametersNode) {
        this.parametersNode = parametersNode;
    }

    @Override
    public <R, P> R accept(ExpressionNodeVisitor<R, P> visitor, P p) {
        return visitor.visitFunctionOperatorNode(this, p);
    }

    @Override
    public ExpressionLocation getLocation() {
        return this.location;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    public String toString() {
        return "@" + this.expression + String.valueOf(this.parametersNode);
    }
}

