/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.seasar.doma.internal.jdbc.command.MappingSupport;

class ColumnNameMapFormatter {
    ColumnNameMapFormatter() {
    }

    static String format(Map<String, MappingSupport.PropType> columnNameMap) {
        Objects.requireNonNull(columnNameMap);
        StringBuilder buf = new StringBuilder();
        buf.append("------------------------------------------------------\n");
        buf.append("Lowercase Column Name -> Property Name (Entity Name)\n");
        buf.append("------------------------------------------------------\n");
        TreeMap<String, MappingSupport.PropType> sortedMap = new TreeMap<String, MappingSupport.PropType>(columnNameMap);
        for (Map.Entry<String, MappingSupport.PropType> entry : sortedMap.entrySet()) {
            String columnName = entry.getKey();
            MappingSupport.PropType propType = entry.getValue();
            buf.append(columnName);
            buf.append(" -> ");
            buf.append(propType.name());
            buf.append(" (");
            buf.append(propType.entityType().getName());
            buf.append(")\n");
        }
        buf.append("------------------------------------------------------");
        return buf.toString();
    }
}

