/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.seasar.doma.internal.jdbc.command.ColumnNameMapFormatter;
import org.seasar.doma.jdbc.DuplicateColumnHandler;
import org.seasar.doma.jdbc.Naming;
import org.seasar.doma.jdbc.ResultMappingException;
import org.seasar.doma.jdbc.Sql;
import org.seasar.doma.jdbc.UnknownColumnHandler;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.NamingType;
import org.seasar.doma.jdbc.entity.Property;
import org.seasar.doma.jdbc.query.Query;
import org.seasar.doma.wrapper.Wrapper;

public class MappingSupport {
    private final EntityType<?> entityType;
    private final Query query;
    private final boolean resultMappingEnsured;
    private final UnknownColumnHandler unknownColumnHandler;
    private final DuplicateColumnHandler duplicateColumnHandler;

    public MappingSupport(EntityType<?> entityType, Query query, boolean resultMappingEnsured, UnknownColumnHandler unknownColumnHandler, DuplicateColumnHandler duplicateColumnHandler) {
        this.entityType = Objects.requireNonNull(entityType);
        this.query = Objects.requireNonNull(query);
        this.resultMappingEnsured = resultMappingEnsured;
        this.unknownColumnHandler = Objects.requireNonNull(unknownColumnHandler);
        this.duplicateColumnHandler = Objects.requireNonNull(duplicateColumnHandler);
    }

    public Map<Integer, PropType> createIndexMap(ResultSetMetaData resultSetMeta, Map<String, PropType> columnNameMap) throws SQLException {
        HashMap<Integer, PropType> indexMap = new HashMap<Integer, PropType>();
        HashSet<PropType> unmappedPropertySet = this.resultMappingEnsured ? new HashSet<PropType>(columnNameMap.values()) : new HashSet();
        HashSet<String> seenColumnNames = new HashSet<String>();
        int count = resultSetMeta.getColumnCount();
        for (int i = 1; i < count + 1; ++i) {
            PropType propertyType;
            String columnName = resultSetMeta.getColumnLabel(i);
            String lowerCaseColumnName = columnName.toLowerCase();
            if (!seenColumnNames.add(lowerCaseColumnName)) {
                this.duplicateColumnHandler.handle(this.query, lowerCaseColumnName);
            }
            if ((propertyType = columnNameMap.get(lowerCaseColumnName)) == null) {
                if ("doma_rownumber_".equals(lowerCaseColumnName)) continue;
                this.unknownColumnHandler.handle(this.query, this.entityType, lowerCaseColumnName, () -> ColumnNameMapFormatter.format(columnNameMap));
                continue;
            }
            unmappedPropertySet.remove(propertyType);
            indexMap.put(i, propertyType);
        }
        if (this.resultMappingEnsured && !unmappedPropertySet.isEmpty()) {
            this.throwResultMappingException(unmappedPropertySet);
        }
        return indexMap;
    }

    private void throwResultMappingException(Set<PropType> unmappedPropertySet) {
        Naming naming = this.query.getConfig().getNaming();
        int size = unmappedPropertySet.size();
        ArrayList<String> unmappedPropertyNames = new ArrayList<String>(size);
        ArrayList<String> expectedColumnNames = new ArrayList<String>(size);
        for (PropType propType : unmappedPropertySet) {
            unmappedPropertyNames.add(propType.name());
            expectedColumnNames.add(propType.columnName(naming::apply));
        }
        Iterator<PropType> iterator = unmappedPropertySet.iterator();
        Class<?> entityClass = iterator.hasNext() ? iterator.next().entityType().getEntityClass() : this.entityType.getEntityClass();
        Sql<?> sql = this.query.getSql();
        throw new ResultMappingException(this.query.getConfig().getExceptionSqlLogType(), entityClass.getName(), unmappedPropertyNames, expectedColumnNames, sql.getKind(), sql.getRawSql(), sql.getFormattedSql(), sql.getSqlFilePath());
    }

    public record PropType(EntityType<?> entityType, EntityPropertyType<?, ?> propertyType, String propertyPath) {
        public PropType {
            Objects.requireNonNull(entityType);
            Objects.requireNonNull(propertyType);
            Objects.requireNonNull(propertyPath);
        }

        public String name() {
            return this.propertyType.getName();
        }

        public String columnName(BiFunction<NamingType, String, String> namingFunction) {
            return this.propertyType.getColumnName(namingFunction);
        }
    }

    public record Prop(PropType propType, Property<Object, ?> property, Object rawValue) {
        public Prop {
            Objects.requireNonNull(propType);
            Objects.requireNonNull(property);
        }

        public EntityType<?> entityType() {
            return this.propType.entityType();
        }

        public String propertyPath() {
            return this.propType.propertyPath();
        }

        public String name() {
            return this.propType.propertyType().getName();
        }

        public boolean isId() {
            return this.propType.propertyType().isId();
        }

        public Wrapper<?> wrapper() {
            return this.property.getWrapper();
        }
    }
}

