/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.dialect;

import java.util.Objects;
import org.seasar.doma.internal.jdbc.dialect.StandardForUpdateTransformer;
import org.seasar.doma.internal.jdbc.sql.node.ForUpdateClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.FragmentNode;
import org.seasar.doma.internal.jdbc.sql.node.SelectStatementNode;
import org.seasar.doma.jdbc.SelectForUpdateType;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.jdbc.dialect.MysqlDialect;

public class MysqlForUpdateTransformer
extends StandardForUpdateTransformer {
    private final MysqlDialect.MySqlVersion version;

    public MysqlForUpdateTransformer(SelectForUpdateType forUpdateType, int waitSeconds, String ... aliases) {
        this(forUpdateType, waitSeconds, aliases, MysqlDialect.DEFAULT_VERSION);
    }

    public MysqlForUpdateTransformer(SelectForUpdateType forUpdateType, int waitSeconds, String[] aliases, MysqlDialect.MySqlVersion version) {
        super(forUpdateType, waitSeconds, aliases);
        this.version = Objects.requireNonNull(version);
    }

    @Override
    public SqlNode visitSelectStatementNode(SelectStatementNode node, Void p) {
        if (this.processed) {
            return node;
        }
        this.processed = true;
        SelectStatementNode result = new SelectStatementNode();
        result.setSelectClauseNode(node.getSelectClauseNode());
        result.setFromClauseNode(node.getFromClauseNode());
        result.setWhereClauseNode(node.getWhereClauseNode());
        result.setGroupByClauseNode(node.getGroupByClauseNode());
        result.setHavingClauseNode(node.getHavingClauseNode());
        result.setOrderByClauseNode(node.getOrderByClauseNode());
        result.setForUpdateClauseNode(this.createForUpdateClauseNode());
        result.setOptionClauseNode(node.getOptionClauseNode());
        return result;
    }

    protected ForUpdateClauseNode createForUpdateClauseNode() {
        ForUpdateClauseNode forUpdate = new ForUpdateClauseNode("for update");
        switch (this.version) {
            case V5: {
                break;
            }
            case V8: {
                StringBuilder buf = new StringBuilder(100);
                if (this.aliases.length > 0) {
                    buf.append(" of ");
                    for (String alias : this.aliases) {
                        buf.append(alias);
                        buf.append(", ");
                    }
                    buf.setLength(buf.length() - 2);
                }
                if (this.forUpdateType == SelectForUpdateType.NOWAIT) {
                    buf.append(" nowait ");
                }
                forUpdate.appendNode(new FragmentNode(buf.toString()));
            }
        }
        return forUpdate;
    }
}

