/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.entity;

import java.lang.reflect.Field;
import java.util.LinkedList;
import org.seasar.doma.internal.WrapException;
import org.seasar.doma.internal.jdbc.entity.FieldWrapper;
import org.seasar.doma.internal.jdbc.entity.PropertyPath;
import org.seasar.doma.internal.jdbc.entity.PropertyPathSegment;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.entity.EntityPropertyAccessException;
import org.seasar.doma.jdbc.entity.EntityPropertyNotFoundException;

public class PropertyField<ENTITY> {
    protected final String path;
    protected final Class<ENTITY> entityClass;
    protected final LinkedList<FieldWrapper> fields = new LinkedList();

    public PropertyField(String path, Class<ENTITY> entityClass) {
        this(PropertyPath.of(path), entityClass);
    }

    public PropertyField(PropertyPath path, Class<ENTITY> entityClass) {
        AssertionUtil.assertNotNull((Object)path, entityClass);
        this.path = path.name();
        this.entityClass = entityClass;
        Class<Object> clazz = entityClass;
        for (PropertyPathSegment propertyPathSegment : path.segments()) {
            FieldWrapper field = this.getField(clazz, propertyPathSegment);
            this.fields.add(field);
            clazz = field.getType();
        }
        AssertionUtil.assertTrue(this.fields.size() > 0, new Object[0]);
    }

    private FieldWrapper getField(Class<?> clazz, PropertyPathSegment segment) {
        Field field = this.findField(clazz, segment.name());
        if (field == null) {
            throw new EntityPropertyNotFoundException(clazz.getName(), segment.name());
        }
        try {
            return segment.wrapField(field);
        }
        catch (WrapException wrapException) {
            throw new EntityPropertyAccessException(wrapException.getCause(), clazz.getName(), segment.name());
        }
    }

    private Field findField(Class<?> clazz, String name) {
        for (Class<?> cl = clazz; cl != Object.class; cl = cl.getSuperclass()) {
            try {
                return cl.getDeclaredField(name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    public Object getValue(ENTITY entity) {
        AssertionUtil.assertNotNull(entity);
        Object value = entity;
        for (FieldWrapper field : this.fields) {
            if (value == null) break;
            value = this.getFieldValue(field, value);
        }
        return value;
    }

    private Object getFieldValue(FieldWrapper field, Object target) {
        try {
            return field.get(target);
        }
        catch (WrapException wrapException) {
            throw new EntityPropertyAccessException(wrapException.getCause(), this.entityClass.getName(), this.path);
        }
    }

    public void setValue(ENTITY entity, Object value) {
        AssertionUtil.assertNotNull(entity);
        if (this.fields.size() > 1) {
            throw new UnsupportedOperationException();
        }
        this.setFieldValue(this.fields.getFirst(), entity, value);
    }

    private void setFieldValue(FieldWrapper field, ENTITY entity, Object value) {
        try {
            field.set(entity, value);
        }
        catch (WrapException wrapException) {
            throw new EntityPropertyAccessException(wrapException.getCause(), this.entityClass.getName(), this.path);
        }
    }

    public boolean isPrimitive() {
        FieldWrapper field = this.fields.getLast();
        return field.getType().isPrimitive();
    }
}

