/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.entity;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.seasar.doma.internal.jdbc.entity.PropertyPathSegment;

public record PropertyPath(List<? extends PropertyPathSegment> segments) {
    public PropertyPath {
        if (segments.isEmpty()) {
            throw new IllegalArgumentException("segments");
        }
    }

    public String name() {
        return this.segments.stream().map(PropertyPathSegment::name).collect(Collectors.joining("."));
    }

    public static PropertyPath combine(PropertyPath path, PropertyPathSegment segment) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(segment);
        List<PropertyPathSegment> segments = Stream.concat(path.segments.stream(), Stream.of(segment)).toList();
        return new PropertyPath(segments);
    }

    public static PropertyPath of(String path) {
        Objects.requireNonNull(path);
        List<PropertyPathSegment.Default> segments = Arrays.stream(path.split("\\.")).map(PropertyPathSegment.Default::new).toList();
        return new PropertyPath(segments);
    }

    @Override
    public String toString() {
        return this.name();
    }
}

