/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.entity;

import java.lang.reflect.Field;
import java.util.Objects;
import org.seasar.doma.internal.WrapException;
import org.seasar.doma.internal.jdbc.entity.FieldWrapper;
import org.seasar.doma.internal.util.FieldUtil;

public interface PropertyPathSegment {
    public String name();

    public FieldWrapper wrapField(Field var1) throws WrapException;

    public record Optional(String name, Class<?> elementClass) implements PropertyPathSegment
    {
        public Optional {
            Objects.requireNonNull(name);
            Objects.requireNonNull(elementClass);
        }

        @Override
        public FieldWrapper wrapField(Field field) throws WrapException {
            if (!field.getType().equals(java.util.Optional.class)) {
                throw new IllegalArgumentException("field must be of type java.util.Optional: " + String.valueOf(field));
            }
            Default segment = new Default(this.name);
            final FieldWrapper fieldWrapper = segment.wrapField(field);
            return new FieldWrapper(){

                @Override
                public Object get(Object obj) throws WrapException {
                    java.util.Optional optional = (java.util.Optional)fieldWrapper.get(obj);
                    return optional != null ? optional.orElse(null) : null;
                }

                @Override
                public void set(Object obj, Object value) throws WrapException {
                    fieldWrapper.set(obj, value);
                }

                @Override
                public Class<?> getType() {
                    return elementClass;
                }
            };
        }
    }

    public record Default(String name) implements PropertyPathSegment
    {
        public Default {
            Objects.requireNonNull(name);
        }

        @Override
        public FieldWrapper wrapField(final Field field) throws WrapException {
            if (!FieldUtil.isPublic(field)) {
                FieldUtil.setAccessible(field, true);
            }
            return new FieldWrapper(){

                @Override
                public Object get(Object obj) throws WrapException {
                    return FieldUtil.get(field, obj);
                }

                @Override
                public void set(Object obj, Object value) throws WrapException {
                    FieldUtil.set(field, obj, value);
                }

                @Override
                public Class<?> getType() {
                    return field.getType();
                }
            };
        }
    }
}

