/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.sql;

import java.nio.CharBuffer;
import org.seasar.doma.internal.expr.util.ExpressionUtil;
import org.seasar.doma.internal.jdbc.sql.SqlTokenType;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.internal.util.ClassicSqlTokenUtil;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

@Deprecated
public class ClassicSqlTokenizer {
    protected final String sql;
    protected final CharBuffer buf;
    protected final CharBuffer duplicatedBuf;
    protected SqlTokenType type;
    protected String token;
    protected int currentLineNumber;
    protected int lineNumber;
    protected int lineStartPosition;
    protected int position;

    public ClassicSqlTokenizer(String sql) {
        AssertionUtil.assertNotNull(sql);
        this.sql = sql;
        this.buf = CharBuffer.wrap(sql);
        this.duplicatedBuf = this.buf.duplicate();
        this.currentLineNumber = 1;
        this.lineNumber = 1;
        this.peek();
    }

    public SqlTokenType next() {
        switch (this.type) {
            case EOF: {
                this.token = null;
                return SqlTokenType.EOF;
            }
            case EOL: {
                this.lineStartPosition = this.buf.position();
            }
        }
        SqlTokenType currentType = this.type;
        this.prepareToken();
        this.peek();
        return currentType;
    }

    protected void prepareToken() {
        this.lineNumber = this.currentLineNumber;
        this.position = this.buf.position() - this.lineStartPosition;
        this.duplicatedBuf.limit(this.buf.position());
        this.token = this.duplicatedBuf.toString();
        this.duplicatedBuf.position(this.buf.position());
    }

    public String getToken() {
        return this.token;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getPosition() {
        return this.position;
    }

    protected void peek() {
        if (this.buf.hasRemaining()) {
            char c = this.buf.get();
            if (this.buf.hasRemaining()) {
                char c2 = this.buf.get();
                if (this.buf.hasRemaining()) {
                    char c3 = this.buf.get();
                    if (this.buf.hasRemaining()) {
                        char c4 = this.buf.get();
                        if (this.buf.hasRemaining()) {
                            char c5 = this.buf.get();
                            if (this.buf.hasRemaining()) {
                                char c6 = this.buf.get();
                                if (this.buf.hasRemaining()) {
                                    char c7 = this.buf.get();
                                    if (this.buf.hasRemaining()) {
                                        char c8 = this.buf.get();
                                        if (this.buf.hasRemaining()) {
                                            char c9 = this.buf.get();
                                            if (this.buf.hasRemaining()) {
                                                char c10 = this.buf.get();
                                                this.peekTenChars(c, c2, c3, c4, c5, c6, c7, c8, c9, c10);
                                            } else {
                                                this.peekNineChars(c, c2, c3, c4, c5, c6, c7, c8, c9);
                                            }
                                        } else {
                                            this.peekEightChars(c, c2, c3, c4, c5, c6, c7, c8);
                                        }
                                    } else {
                                        this.peekSevenChars(c, c2, c3, c4, c5, c6, c7);
                                    }
                                } else {
                                    this.peekSixChars(c, c2, c3, c4, c5, c6);
                                }
                            } else {
                                this.peekFiveChars(c, c2, c3, c4, c5);
                            }
                        } else {
                            this.peekFourChars(c, c2, c3, c4);
                        }
                    } else {
                        this.peekThreeChars(c, c2, c3);
                    }
                } else {
                    this.peekTwoChars(c, c2);
                }
            } else {
                this.peekOneChar(c);
            }
        } else {
            this.type = SqlTokenType.EOF;
        }
    }

    protected void peekTenChars(char c, char c2, char c3, char c4, char c5, char c6, char c7, char c8, char c9, char c10) {
        if (!(c != 'f' && c != 'F' || c2 != 'o' && c2 != 'O' || c3 != 'r' && c3 != 'R' || !this.isWhitespace(c4) || c5 != 'u' && c5 != 'U' || c6 != 'p' && c6 != 'P' || c7 != 'd' && c7 != 'D' || c8 != 'a' && c8 != 'A' || c9 != 't' && c9 != 'T' || c10 != 'e' && c10 != 'E')) {
            this.type = SqlTokenType.FOR_UPDATE_WORD;
            if (this.isWordTerminated()) {
                return;
            }
        }
        this.buf.position(this.buf.position() - 1);
        this.peekNineChars(c, c2, c3, c4, c5, c6, c7, c8, c9);
    }

    protected void peekNineChars(char c, char c2, char c3, char c4, char c5, char c6, char c7, char c8, char c9) {
        if (!(c != 'i' && c != 'I' || c2 != 'n' && c2 != 'N' || c3 != 't' && c3 != 'T' || c4 != 'e' && c4 != 'E' || c5 != 'r' && c5 != 'R' || c6 != 's' && c6 != 'S' || c7 != 'e' && c7 != 'E' || c8 != 'c' && c8 != 'C' || c9 != 't' && c9 != 'T')) {
            this.type = SqlTokenType.INTERSECT_WORD;
            if (this.isWordTerminated()) {
                return;
            }
        }
        this.buf.position(this.buf.position() - 1);
        this.peekEightChars(c, c2, c3, c4, c5, c6, c7, c8);
    }

    protected void peekEightChars(char c, char c2, char c3, char c4, char c5, char c6, char c7, char c8) {
        if (!(c != 'g' && c != 'G' || c2 != 'r' && c2 != 'R' || c3 != 'o' && c3 != 'O' || c4 != 'u' && c4 != 'U' || c5 != 'p' && c5 != 'P' || !this.isWhitespace(c6) || c7 != 'b' && c7 != 'B' || c8 != 'y' && c8 != 'Y')) {
            this.type = SqlTokenType.GROUP_BY_WORD;
            if (this.isWordTerminated()) {
                return;
            }
        } else if (!(c != 'o' && c != 'O' || c2 != 'r' && c2 != 'R' || c3 != 'd' && c3 != 'D' || c4 != 'e' && c4 != 'E' || c5 != 'r' && c5 != 'R' || !Character.isWhitespace(c6) || c7 != 'b' && c7 != 'B' || c8 != 'y' && c8 != 'Y')) {
            this.type = SqlTokenType.ORDER_BY_WORD;
            if (this.isWordTerminated()) {
                return;
            }
        } else {
            if (!(c != 'o' && c != 'O' || c2 != 'p' && c2 != 'P' || c3 != 't' && c3 != 'T' || c4 != 'i' && c4 != 'I' || c5 != 'o' && c5 != 'O' || c6 != 'n' && c6 != 'N' || !this.isWhitespace(c7) || c8 != '(')) {
                this.type = SqlTokenType.OPTION_WORD;
                this.buf.position(this.buf.position() - 2);
                return;
            }
            if (!(c != 'd' && c != 'D' || c2 != 'i' && c2 != 'I' || c3 != 's' && c3 != 'S' || c4 != 't' && c4 != 'T' || c5 != 'i' && c5 != 'I' || c6 != 'n' && c6 != 'N' || c7 != 'c' && c7 != 'C' || c8 != 't' && c8 != 'T')) {
                this.type = SqlTokenType.DISTINCT_WORD;
                if (this.isWordTerminated()) {
                    return;
                }
            }
        }
        this.buf.position(this.buf.position() - 1);
        this.peekSevenChars(c, c2, c3, c4, c5, c6, c7);
    }

    protected void peekSevenChars(char c, char c2, char c3, char c4, char c5, char c6, char c7) {
        this.buf.position(this.buf.position() - 1);
        this.peekSixChars(c, c2, c3, c4, c5, c6);
    }

    protected void peekSixChars(char c, char c2, char c3, char c4, char c5, char c6) {
        if (!(c != 's' && c != 'S' || c2 != 'e' && c2 != 'E' || c3 != 'l' && c3 != 'L' || c4 != 'e' && c4 != 'E' || c5 != 'c' && c5 != 'C' || c6 != 't' && c6 != 'T')) {
            this.type = SqlTokenType.SELECT_WORD;
            if (this.isWordTerminated()) {
                return;
            }
        } else if (!(c != 'h' && c != 'H' || c2 != 'a' && c2 != 'A' || c3 != 'v' && c3 != 'V' || c4 != 'i' && c4 != 'I' || c5 != 'n' && c5 != 'N' || c6 != 'g' && c6 != 'G')) {
            this.type = SqlTokenType.HAVING_WORD;
            if (this.isWordTerminated()) {
                return;
            }
        } else if (!(c != 'e' && c != 'E' || c2 != 'x' && c2 != 'X' || c3 != 'c' && c3 != 'C' || c4 != 'e' && c4 != 'E' || c5 != 'p' && c5 != 'P' || c6 != 't' && c6 != 'T')) {
            this.type = SqlTokenType.EXCEPT_WORD;
            if (this.isWordTerminated()) {
                return;
            }
        } else if (!(c != 'u' && c != 'U' || c2 != 'p' && c2 != 'P' || c3 != 'd' && c3 != 'D' || c4 != 'a' && c4 != 'A' || c5 != 't' && c5 != 'T' || c6 != 'e' && c6 != 'E')) {
            this.type = SqlTokenType.UPDATE_WORD;
            if (this.isWordTerminated()) {
                return;
            }
        }
        this.buf.position(this.buf.position() - 1);
        this.peekFiveChars(c, c2, c3, c4, c5);
    }

    protected void peekFiveChars(char c, char c2, char c3, char c4, char c5) {
        if (!(c != 'w' && c != 'W' || c2 != 'h' && c2 != 'H' || c3 != 'e' && c3 != 'E' || c4 != 'r' && c4 != 'R' || c5 != 'e' && c5 != 'E')) {
            this.type = SqlTokenType.WHERE_WORD;
            if (this.isWordTerminated()) {
                return;
            }
        } else if (!(c != 'u' && c != 'U' || c2 != 'n' && c2 != 'N' || c3 != 'i' && c3 != 'I' || c4 != 'o' && c4 != 'O' || c5 != 'n' && c5 != 'N')) {
            this.type = SqlTokenType.UNION_WORD;
            if (this.isWordTerminated()) {
                return;
            }
        } else if (!(c != 'm' && c != 'M' || c2 != 'i' && c2 != 'I' || c3 != 'n' && c3 != 'N' || c4 != 'u' && c4 != 'U' || c5 != 's' && c5 != 'S')) {
            this.type = SqlTokenType.MINUS_WORD;
            if (this.isWordTerminated()) {
                return;
            }
        }
        this.buf.position(this.buf.position() - 1);
        this.peekFourChars(c, c2, c3, c4);
    }

    protected void peekFourChars(char c, char c2, char c3, char c4) {
        if (!(c != 'f' && c != 'F' || c2 != 'r' && c2 != 'R' || c3 != 'o' && c3 != 'O' || c4 != 'm' && c4 != 'M')) {
            this.type = SqlTokenType.FROM_WORD;
            if (this.isWordTerminated()) {
                return;
            }
        }
        this.buf.position(this.buf.position() - 1);
        this.peekThreeChars(c, c2, c3);
    }

    protected void peekThreeChars(char c, char c2, char c3) {
        if (!(c != 'a' && c != 'A' || c2 != 'n' && c2 != 'N' || c3 != 'd' && c3 != 'D')) {
            this.type = SqlTokenType.AND_WORD;
            if (this.isWordTerminated()) {
                return;
            }
        } else if (!(c != 's' && c != 'S' || c2 != 'e' && c2 != 'E' || c3 != 't' && c3 != 'T')) {
            this.type = SqlTokenType.SET_WORD;
            if (this.isWordTerminated()) {
                return;
            }
        }
        this.buf.position(this.buf.position() - 1);
        this.peekTwoChars(c, c2);
    }

    protected void peekTwoChars(char c, char c2) {
        if (!(c != 'o' && c != 'O' || c2 != 'r' && c2 != 'R')) {
            this.type = SqlTokenType.OR_WORD;
            if (this.isWordTerminated()) {
                return;
            }
        } else if (!(c != 'i' && c != 'I' || c2 != 'n' && c2 != 'N')) {
            this.type = SqlTokenType.IN_WORD;
            if (this.isWordTerminated()) {
                return;
            }
        } else {
            if (c == '/' && c2 == '*') {
                char c4;
                char c3;
                this.type = SqlTokenType.BLOCK_COMMENT;
                if (this.buf.hasRemaining()) {
                    c3 = this.buf.get();
                    if (ExpressionUtil.isExpressionIdentifierStart(c3)) {
                        this.type = SqlTokenType.BIND_VARIABLE_BLOCK_COMMENT;
                    } else if (c3 == '^') {
                        this.type = SqlTokenType.LITERAL_VARIABLE_BLOCK_COMMENT;
                    } else if (c3 == '#') {
                        this.type = SqlTokenType.EMBEDDED_VARIABLE_BLOCK_COMMENT;
                    } else if (c3 == '%') {
                        if (this.buf.hasRemaining()) {
                            c4 = this.buf.get();
                            if (c4 == '!') {
                                this.type = SqlTokenType.PARSER_LEVEL_BLOCK_COMMENT;
                            } else if (this.buf.hasRemaining()) {
                                char c5 = this.buf.get();
                                if (c4 == 'i' && c5 == 'f') {
                                    if (this.isBlockCommentDirectiveTerminated()) {
                                        this.type = SqlTokenType.IF_BLOCK_COMMENT;
                                    }
                                } else if (this.buf.hasRemaining()) {
                                    char c6 = this.buf.get();
                                    if (c4 == 'f' && c5 == 'o' && c6 == 'r') {
                                        if (this.isBlockCommentDirectiveTerminated()) {
                                            this.type = SqlTokenType.FOR_BLOCK_COMMENT;
                                        }
                                    } else if (c4 == 'e' && c5 == 'n' && c6 == 'd') {
                                        if (this.isBlockCommentDirectiveTerminated()) {
                                            this.type = SqlTokenType.END_BLOCK_COMMENT;
                                        }
                                    } else if (this.buf.hasRemaining()) {
                                        char c7 = this.buf.get();
                                        if (c4 == 'e' && c5 == 'l' && c6 == 's' && c7 == 'e') {
                                            if (this.isBlockCommentDirectiveTerminated()) {
                                                this.type = SqlTokenType.ELSE_BLOCK_COMMENT;
                                            } else if (this.buf.hasRemaining()) {
                                                c8 = this.buf.get();
                                                if (this.buf.hasRemaining()) {
                                                    c9 = this.buf.get();
                                                    if (c8 == 'i' && c9 == 'f') {
                                                        if (this.isBlockCommentDirectiveTerminated()) {
                                                            this.type = SqlTokenType.ELSEIF_BLOCK_COMMENT;
                                                        }
                                                    } else {
                                                        this.buf.position(this.buf.position() - 6);
                                                    }
                                                } else {
                                                    this.buf.position(this.buf.position() - 5);
                                                }
                                            }
                                        } else if (this.buf.hasRemaining()) {
                                            c8 = this.buf.get();
                                            if (this.buf.hasRemaining()) {
                                                c9 = this.buf.get();
                                                if (c4 == 'e' && c5 == 'x' && c6 == 'p' && c7 == 'a' && c8 == 'n' && c9 == 'd') {
                                                    if (this.isBlockCommentDirectiveTerminated()) {
                                                        this.type = SqlTokenType.EXPAND_BLOCK_COMMENT;
                                                    }
                                                } else if (this.buf.hasRemaining()) {
                                                    char c10 = this.buf.get();
                                                    if (this.buf.hasRemaining()) {
                                                        char c11 = this.buf.get();
                                                        if (c4 == 'p' && c5 == 'o' && c6 == 'p' && c7 == 'u' && c8 == 'l' && c9 == 'a' && c10 == 't' && c11 == 'e') {
                                                            if (this.isBlockCommentDirectiveTerminated()) {
                                                                this.type = SqlTokenType.POPULATE_BLOCK_COMMENT;
                                                            }
                                                        } else {
                                                            this.buf.position(this.buf.position() - 8);
                                                        }
                                                    } else {
                                                        this.buf.position(this.buf.position() - 7);
                                                    }
                                                } else {
                                                    this.buf.position(this.buf.position() - 6);
                                                }
                                            } else {
                                                this.buf.position(this.buf.position() - 5);
                                            }
                                        } else {
                                            this.buf.position(this.buf.position() - 4);
                                        }
                                    } else {
                                        this.buf.position(this.buf.position() - 3);
                                    }
                                } else {
                                    this.buf.position(this.buf.position() - 2);
                                }
                            } else {
                                this.buf.position(this.buf.position() - 1);
                            }
                        }
                        if (this.type != SqlTokenType.PARSER_LEVEL_BLOCK_COMMENT && this.type != SqlTokenType.IF_BLOCK_COMMENT && this.type != SqlTokenType.FOR_BLOCK_COMMENT && this.type != SqlTokenType.END_BLOCK_COMMENT && this.type != SqlTokenType.ELSE_BLOCK_COMMENT && this.type != SqlTokenType.ELSEIF_BLOCK_COMMENT && this.type != SqlTokenType.EXPAND_BLOCK_COMMENT && this.type != SqlTokenType.POPULATE_BLOCK_COMMENT) {
                            int pos = this.buf.position() - this.lineStartPosition;
                            throw new JdbcException((MessageResource)Message.DOMA2119, this.sql, this.lineNumber, pos);
                        }
                    }
                    this.buf.position(this.buf.position() - 1);
                }
                while (this.buf.hasRemaining()) {
                    c3 = this.buf.get();
                    if (!this.buf.hasRemaining()) continue;
                    this.buf.mark();
                    c4 = this.buf.get();
                    if (c3 == '*' && c4 == '/') {
                        return;
                    }
                    if (c3 == '\r' || c3 == '\n') {
                        ++this.currentLineNumber;
                    }
                    this.buf.reset();
                }
                int pos = this.buf.position() - this.lineStartPosition;
                throw new JdbcException((MessageResource)Message.DOMA2102, this.sql, this.lineNumber, pos);
            }
            if (c == '-' && c2 == '-') {
                this.type = SqlTokenType.LINE_COMMENT;
                while (this.buf.hasRemaining()) {
                    this.buf.mark();
                    char c3 = this.buf.get();
                    if (c3 != '\r' && c3 != '\n') continue;
                    this.buf.reset();
                    return;
                }
                return;
            }
            if (c == '\r' && c2 == '\n') {
                this.type = SqlTokenType.EOL;
                ++this.currentLineNumber;
                return;
            }
        }
        this.buf.position(this.buf.position() - 1);
        this.peekOneChar(c);
    }

    protected void peekOneChar(char c) {
        if (this.isWhitespace(c)) {
            this.type = SqlTokenType.WHITESPACE;
        } else if (c == '(') {
            this.type = SqlTokenType.OPENED_PARENS;
        } else if (c == ')') {
            this.type = SqlTokenType.CLOSED_PARENS;
        } else if (c == ';') {
            this.type = SqlTokenType.DELIMITER;
        } else {
            if (c == '\'') {
                this.type = SqlTokenType.QUOTE;
                boolean closed = false;
                while (this.buf.hasRemaining()) {
                    char c2 = this.buf.get();
                    if (c2 != '\'') continue;
                    if (this.buf.hasRemaining()) {
                        this.buf.mark();
                        char c3 = this.buf.get();
                        if (c3 == '\'') continue;
                        this.buf.reset();
                        closed = true;
                        break;
                    }
                    closed = true;
                }
                if (closed) {
                    return;
                }
                int pos = this.buf.position() - this.lineStartPosition;
                throw new JdbcException((MessageResource)Message.DOMA2101, this.sql, this.lineNumber, pos);
            }
            if (this.isWordStart(c)) {
                this.type = SqlTokenType.WORD;
                while (this.buf.hasRemaining()) {
                    this.buf.mark();
                    char c2 = this.buf.get();
                    if (c2 == '\'') {
                        boolean closed = false;
                        while (this.buf.hasRemaining()) {
                            char c3 = this.buf.get();
                            if (c3 != '\'') continue;
                            if (this.buf.hasRemaining()) {
                                this.buf.mark();
                                char c4 = this.buf.get();
                                if (c4 == '\'') continue;
                                this.buf.reset();
                                closed = true;
                                break;
                            }
                            closed = true;
                        }
                        if (closed) {
                            return;
                        }
                        int pos = this.buf.position() - this.lineStartPosition;
                        throw new JdbcException((MessageResource)Message.DOMA2101, this.sql, this.lineNumber, pos);
                    }
                    if (this.isWordPart(c2)) continue;
                    this.buf.reset();
                    return;
                }
            } else if (c == '\r' || c == '\n') {
                this.type = SqlTokenType.EOL;
                ++this.currentLineNumber;
            } else {
                this.type = SqlTokenType.OTHER;
            }
        }
    }

    protected boolean isWordStart(char c) {
        if (c == '+' || c == '-') {
            this.buf.mark();
            if (this.buf.hasRemaining()) {
                char c2 = this.buf.get();
                this.buf.reset();
                if (Character.isDigit(c2)) {
                    return true;
                }
            }
        }
        return this.isWordPart(c);
    }

    protected boolean isWordTerminated() {
        this.buf.mark();
        if (this.buf.hasRemaining()) {
            char c = this.buf.get();
            this.buf.reset();
            return !this.isWordPart(c);
        }
        return true;
    }

    protected boolean isBlockCommentDirectiveTerminated() {
        this.buf.mark();
        if (this.buf.hasRemaining()) {
            char c = this.buf.get();
            this.buf.reset();
            return !this.isWordPart(c);
        }
        return true;
    }

    protected boolean isWordPart(char c) {
        return ClassicSqlTokenUtil.isWordPart(c);
    }

    protected boolean isWhitespace(char c) {
        return ClassicSqlTokenUtil.isWhitespace(c);
    }
}

