/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.sql;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.seasar.doma.internal.jdbc.sql.SqlTokenType;
import org.seasar.doma.internal.jdbc.sql.SqlTokenizer;
import org.seasar.doma.internal.jdbc.sql.node.AnonymousNode;
import org.seasar.doma.internal.jdbc.sql.node.AppendableSqlNode;
import org.seasar.doma.internal.jdbc.sql.node.BindVariableNode;
import org.seasar.doma.internal.jdbc.sql.node.BlockNode;
import org.seasar.doma.internal.jdbc.sql.node.CommentNode;
import org.seasar.doma.internal.jdbc.sql.node.CommentType;
import org.seasar.doma.internal.jdbc.sql.node.DistinctNode;
import org.seasar.doma.internal.jdbc.sql.node.ElseNode;
import org.seasar.doma.internal.jdbc.sql.node.ElseifNode;
import org.seasar.doma.internal.jdbc.sql.node.EmbeddedVariableNode;
import org.seasar.doma.internal.jdbc.sql.node.EndNode;
import org.seasar.doma.internal.jdbc.sql.node.EolNode;
import org.seasar.doma.internal.jdbc.sql.node.ExpandNode;
import org.seasar.doma.internal.jdbc.sql.node.ForBlockNode;
import org.seasar.doma.internal.jdbc.sql.node.ForNode;
import org.seasar.doma.internal.jdbc.sql.node.ForUpdateClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.FromClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.GroupByClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.HavingClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.IfBlockNode;
import org.seasar.doma.internal.jdbc.sql.node.IfNode;
import org.seasar.doma.internal.jdbc.sql.node.InNode;
import org.seasar.doma.internal.jdbc.sql.node.LiteralVariableNode;
import org.seasar.doma.internal.jdbc.sql.node.LogicalOperatorNode;
import org.seasar.doma.internal.jdbc.sql.node.OptionClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.OrderByClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.OtherNode;
import org.seasar.doma.internal.jdbc.sql.node.ParensNode;
import org.seasar.doma.internal.jdbc.sql.node.PopulateNode;
import org.seasar.doma.internal.jdbc.sql.node.SelectClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.SelectStatementNode;
import org.seasar.doma.internal.jdbc.sql.node.SetClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.SqlLocation;
import org.seasar.doma.internal.jdbc.sql.node.UpdateClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.UpdateStatementNode;
import org.seasar.doma.internal.jdbc.sql.node.ValueNode;
import org.seasar.doma.internal.jdbc.sql.node.WhereClauseAwareNode;
import org.seasar.doma.internal.jdbc.sql.node.WhereClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.WhitespaceNode;
import org.seasar.doma.internal.jdbc.sql.node.WordNode;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.internal.util.StringUtil;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class SqlParser {
    protected static final Pattern LITERAL_PATTERN = Pattern.compile("[-+'.0-9]|.*'|true|false|null", 2);
    protected final Deque<AppendableSqlNode> nodeStack = new LinkedList<AppendableSqlNode>();
    protected final String sql;
    protected final SqlTokenizer tokenizer;
    protected final AnonymousNode rootNode;
    protected SqlTokenType tokenType;
    protected String token;

    public SqlParser(String sql) {
        AssertionUtil.assertNotNull(sql);
        this.sql = sql;
        this.tokenizer = new SqlTokenizer(sql);
        this.rootNode = new AnonymousNode();
        this.nodeStack.push(this.rootNode);
    }

    /*
     * Enabled aggressive block sorting
     */
    public SqlNode parse() {
        block37: while (true) {
            this.tokenType = this.tokenizer.next();
            this.token = this.tokenizer.getToken();
            switch (this.tokenType) {
                case WHITESPACE: {
                    this.parseWhitespace();
                    break;
                }
                case WORD: 
                case QUOTE: {
                    this.parseWord();
                    break;
                }
                case SELECT_WORD: {
                    this.parseSelectWord();
                    break;
                }
                case FROM_WORD: {
                    this.parseFromWord();
                    break;
                }
                case WHERE_WORD: {
                    this.parseWhereWord();
                    break;
                }
                case GROUP_BY_WORD: {
                    this.parseGroupByWord();
                    break;
                }
                case HAVING_WORD: {
                    this.parseHavingWord();
                    break;
                }
                case ORDER_BY_WORD: {
                    this.parseOrderByWord();
                    break;
                }
                case FOR_UPDATE_WORD: {
                    this.parseForUpdateWord();
                    break;
                }
                case OPTION_WORD: {
                    this.parseOptionWord();
                    break;
                }
                case DISTINCT_WORD: {
                    this.parseDistinctWord();
                    break;
                }
                case IN_WORD: {
                    this.parseInWord();
                    break;
                }
                case UPDATE_WORD: {
                    this.parseUpdateWord();
                    break;
                }
                case SET_WORD: {
                    this.parseSetWord();
                    break;
                }
                case AND_WORD: 
                case OR_WORD: {
                    this.parseLogicalWord();
                    break;
                }
                case OPENED_PARENS: {
                    this.parseOpenedParens();
                    break;
                }
                case CLOSED_PARENS: {
                    this.parseClosedParens();
                    break;
                }
                case BIND_VARIABLE_BLOCK_COMMENT: {
                    this.parseBindVariableBlockComment();
                    break;
                }
                case LITERAL_VARIABLE_BLOCK_COMMENT: {
                    this.parseLiteralVariableBlockComment();
                    break;
                }
                case EMBEDDED_VARIABLE_BLOCK_COMMENT: {
                    this.parseEmbeddedVariableBlockComment();
                    break;
                }
                case PARSER_LEVEL_BLOCK_COMMENT: {
                    this.parseParserLevelBlockComment();
                    break;
                }
                case IF_BLOCK_COMMENT: {
                    this.parseIfBlockComment();
                    break;
                }
                case ELSEIF_BLOCK_COMMENT: {
                    this.parseElseifBlockComment();
                    break;
                }
                case ELSE_BLOCK_COMMENT: {
                    this.parseElseBlockComment();
                    break;
                }
                case END_BLOCK_COMMENT: {
                    this.parseEndBlockComment();
                    break;
                }
                case FOR_BLOCK_COMMENT: {
                    this.parseForBlockComment();
                    break;
                }
                case EXPAND_BLOCK_COMMENT: {
                    this.parseExpandBlockComment();
                    break;
                }
                case POPULATE_BLOCK_COMMENT: {
                    this.parsePopulateBlockComment();
                    break;
                }
                case UNION_WORD: 
                case EXCEPT_WORD: 
                case MINUS_WORD: 
                case INTERSECT_WORD: {
                    this.parseSetOperatorWord();
                    break;
                }
                case BLOCK_COMMENT: {
                    this.parseBlockComment();
                    break;
                }
                case LINE_COMMENT: {
                    this.parseLineComment();
                    break;
                }
                case OTHER: {
                    this.parseOther();
                    break;
                }
                case EOL: {
                    this.parseEOL();
                    break;
                }
                case DELIMITER: {
                    this.parseDelimiter();
                    break block37;
                }
                case EOF: {
                    break block37;
                }
            }
        }
        this.validate();
        this.validateParensClosed();
        return this.rootNode;
    }

    protected void parseSetOperatorWord() {
        this.validate();
        AnonymousNode node = new AnonymousNode();
        node.appendNode(new WordNode(this.token, true));
        if (this.isInSelectStatementNode()) {
            this.removeNodesTo(SelectStatementNode.class);
            this.pop();
        }
        this.appendNode(node);
        this.push(node);
    }

    protected void parseSelectWord() {
        this.validate();
        SelectStatementNode selectStatementNode = new SelectStatementNode();
        this.appendNode(selectStatementNode);
        this.push(selectStatementNode);
        SelectClauseNode selectClauseNode = new SelectClauseNode(this.token);
        selectStatementNode.setSelectClauseNode(selectClauseNode);
        this.push(selectClauseNode);
    }

    protected void parseFromWord() {
        this.validate();
        FromClauseNode node = new FromClauseNode(this.token);
        if (this.isInSelectStatementNode()) {
            this.removeNodesTo(SelectStatementNode.class);
            SelectStatementNode selectStatementNode = (SelectStatementNode)this.peek();
            selectStatementNode.setFromClauseNode(node);
        } else {
            this.appendNode(node);
        }
        this.push(node);
    }

    protected void parseWhereWord() {
        this.validate();
        WhereClauseNode node = new WhereClauseNode(this.token);
        if (this.isInWhereClauseAwareNode()) {
            this.removeNodesTo(WhereClauseAwareNode.class);
            WhereClauseAwareNode whereClauseAwareNode = (WhereClauseAwareNode)this.peek();
            whereClauseAwareNode.setWhereClauseNode(node);
        } else {
            this.appendNode(node);
        }
        this.push(node);
    }

    protected void parseGroupByWord() {
        this.validate();
        GroupByClauseNode node = new GroupByClauseNode(this.token);
        if (this.isInSelectStatementNode()) {
            this.removeNodesTo(SelectStatementNode.class);
            SelectStatementNode selectStatementNode = (SelectStatementNode)this.peek();
            selectStatementNode.setGroupByClauseNode(node);
        } else {
            this.appendNode(node);
        }
        this.push(node);
    }

    protected void parseHavingWord() {
        this.validate();
        HavingClauseNode node = new HavingClauseNode(this.token);
        if (this.isInSelectStatementNode()) {
            this.removeNodesTo(SelectStatementNode.class);
            SelectStatementNode selectStatementNode = (SelectStatementNode)this.peek();
            selectStatementNode.setHavingClauseNode(node);
        } else {
            this.appendNode(node);
        }
        this.push(node);
    }

    protected void parseOrderByWord() {
        this.validate();
        OrderByClauseNode node = new OrderByClauseNode(this.token);
        if (this.isInSelectStatementNode()) {
            this.removeNodesTo(SelectStatementNode.class);
            SelectStatementNode selectStatementNode = (SelectStatementNode)this.peek();
            selectStatementNode.setOrderByClauseNode(node);
        } else {
            this.appendNode(node);
        }
        this.push(node);
    }

    protected void parseForUpdateWord() {
        this.validate();
        ForUpdateClauseNode node = new ForUpdateClauseNode(this.token);
        if (this.isInSelectStatementNode()) {
            this.removeNodesTo(SelectStatementNode.class);
            SelectStatementNode selectStatementNode = (SelectStatementNode)this.peek();
            selectStatementNode.setForUpdateClauseNode(node);
        } else {
            this.appendNode(node);
        }
        this.push(node);
    }

    protected void parseOptionWord() {
        this.validate();
        OptionClauseNode node = new OptionClauseNode(this.token);
        if (this.isInSelectStatementNode()) {
            this.removeNodesTo(SelectStatementNode.class);
            SelectStatementNode selectStatementNode = (SelectStatementNode)this.peek();
            selectStatementNode.setOptionClauseNode(node);
        } else {
            this.appendNode(node);
        }
        this.push(node);
    }

    protected void parseUpdateWord() {
        this.validate();
        UpdateStatementNode updateStatementNode = new UpdateStatementNode();
        this.appendNode(updateStatementNode);
        this.push(updateStatementNode);
        UpdateClauseNode updateClauseNode = new UpdateClauseNode(this.token);
        updateStatementNode.setUpdateClauseNode(updateClauseNode);
        this.push(updateClauseNode);
    }

    protected void parseSetWord() {
        this.validate();
        SetClauseNode node = new SetClauseNode(this.token);
        if (this.isInUpdateStatementNode()) {
            this.removeNodesTo(UpdateStatementNode.class);
            UpdateStatementNode updateStatementNode = (UpdateStatementNode)this.peek();
            updateStatementNode.setSetClauseNode(node);
        } else {
            this.appendNode(node);
        }
        this.push(node);
    }

    protected void parseLogicalWord() {
        String word = this.tokenType.extract(this.token);
        LogicalOperatorNode node = new LogicalOperatorNode(word);
        this.appendNode(node);
        this.push(node);
    }

    protected void parseWord() {
        WordNode node = new WordNode(this.token);
        this.appendNode(node);
    }

    protected void parseDistinctWord() {
        DistinctNode node = new DistinctNode(this.token);
        this.appendNode(node);
    }

    protected void parseInWord() {
        InNode node = new InNode(this.token);
        this.appendNode(node);
    }

    protected void parseBlockComment() {
        CommentNode node = new CommentNode(this.token, CommentType.BLOCK);
        this.appendNode(node);
    }

    protected void parseLineComment() {
        CommentNode node = new CommentNode(this.token, CommentType.LINE);
        this.appendNode(node);
    }

    protected void parseOpenedParens() {
        ParensNode parensNode = new ParensNode(this.getLocation());
        this.appendNode(parensNode);
        this.push(parensNode);
    }

    protected void parseClosedParens() {
        if (!this.isInParensNode()) {
            throw new JdbcException((MessageResource)Message.DOMA2109, this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition());
        }
        this.validate();
        this.removeNodesTo(ParensNode.class);
        ParensNode parensNode = (ParensNode)this.pop();
        for (SqlNode child : parensNode.getChildren()) {
            if (child instanceof WhitespaceNode || child instanceof CommentNode) continue;
            parensNode.setEmpty(false);
            break;
        }
        parensNode.close();
    }

    protected void parseBindVariableBlockComment() {
        String variableName = this.tokenType.extract(this.token);
        if (variableName.isEmpty()) {
            throw new JdbcException((MessageResource)Message.DOMA2120, this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition(), this.token);
        }
        BindVariableNode node = new BindVariableNode(this.getLocation(), variableName, this.token);
        InNode inNode = this.findInNode();
        node.setInNode(inNode);
        this.appendNode(node);
        this.push(node);
    }

    protected void parseLiteralVariableBlockComment() {
        String variableName = this.tokenType.extract(this.token);
        if (variableName.isEmpty()) {
            throw new JdbcException((MessageResource)Message.DOMA2228, this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition(), this.token);
        }
        LiteralVariableNode node = new LiteralVariableNode(this.getLocation(), variableName, this.token);
        InNode inNode = this.findInNode();
        node.setInNode(inNode);
        this.appendNode(node);
        this.push(node);
    }

    protected void parseEmbeddedVariableBlockComment() {
        String variableName = this.tokenType.extract(this.token);
        if (variableName.isEmpty()) {
            throw new JdbcException((MessageResource)Message.DOMA2121, this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition(), this.token);
        }
        EmbeddedVariableNode node = new EmbeddedVariableNode(this.getLocation(), variableName, this.token);
        this.appendNode(node);
        this.push(node);
    }

    protected void parseParserLevelBlockComment() {
    }

    protected void parseIfBlockComment() {
        IfBlockNode ifBlockNode = new IfBlockNode();
        this.appendNode(ifBlockNode);
        this.push(ifBlockNode);
        String expression = this.tokenType.extract(this.token);
        if (expression.isEmpty()) {
            throw new JdbcException((MessageResource)Message.DOMA2241, this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition());
        }
        IfNode ifNode = new IfNode(this.getLocation(), expression, this.token);
        ifBlockNode.setIfNode(ifNode);
        this.push(ifNode);
    }

    protected void parseElseifBlockComment() {
        if (!this.isInIfBlockNode()) {
            throw new JdbcException((MessageResource)Message.DOMA2138, this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition());
        }
        this.removeNodesTo(IfBlockNode.class);
        IfBlockNode ifBlockNode = (IfBlockNode)this.peek();
        if (ifBlockNode.isElseNodeExistent()) {
            throw new JdbcException((MessageResource)Message.DOMA2139, this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition());
        }
        String expression = this.tokenType.extract(this.token);
        if (expression.isEmpty()) {
            throw new JdbcException((MessageResource)Message.DOMA2242, this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition());
        }
        ElseifNode node = new ElseifNode(this.getLocation(), expression, this.token);
        ifBlockNode.addElseifNode(node);
        this.push(node);
    }

    protected void parseElseBlockComment() {
        if (!this.isInIfBlockNode()) {
            throw new JdbcException((MessageResource)Message.DOMA2140, this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition());
        }
        this.removeNodesTo(IfBlockNode.class);
        IfBlockNode ifBlockNode = (IfBlockNode)this.peek();
        if (ifBlockNode.isElseNodeExistent()) {
            throw new JdbcException((MessageResource)Message.DOMA2141, this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition());
        }
        ElseNode node = new ElseNode(this.token);
        ifBlockNode.setElseNode(node);
        this.push(node);
    }

    protected void parseEndBlockComment() {
        if (!this.isInBlockNode()) {
            throw new JdbcException((MessageResource)Message.DOMA2104, this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition());
        }
        this.removeNodesTo(BlockNode.class);
        BlockNode blockNode = (BlockNode)this.pop();
        EndNode node = new EndNode(this.token);
        blockNode.setEndNode(node);
        this.push(node);
    }

    protected void parseForBlockComment() {
        ForBlockNode forBlockNode = new ForBlockNode();
        this.appendNode(forBlockNode);
        this.push(forBlockNode);
        String expr = this.tokenType.extract(this.token);
        int pos = expr.indexOf(":");
        if (pos == -1) {
            throw new JdbcException((MessageResource)Message.DOMA2124, this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition());
        }
        String identifier = expr.substring(0, pos).trim();
        if (identifier.isEmpty()) {
            throw new JdbcException((MessageResource)Message.DOMA2125, this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition());
        }
        String expression = expr.substring(pos + 1).trim();
        if (expression.isEmpty()) {
            throw new JdbcException((MessageResource)Message.DOMA2126, this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition());
        }
        ForNode forNode = new ForNode(this.getLocation(), identifier, expression, this.token);
        forBlockNode.setForNode(forNode);
        this.push(forNode);
    }

    protected void parseExpandBlockComment() {
        String alias = this.tokenType.extract(this.token);
        if (alias.isEmpty() || StringUtil.isWhitespace(alias)) {
            alias = "\"\"";
        }
        ExpandNode node = new ExpandNode(this.getLocation(), alias, this.token);
        this.appendNode(node);
        this.push(node);
    }

    protected void parsePopulateBlockComment() {
        PopulateNode node = new PopulateNode(this.getLocation(), this.token);
        this.appendNode(node);
        this.push(node);
    }

    protected void parseOther() {
        this.appendNode(OtherNode.of(this.token));
    }

    protected void parseEOL() {
        EolNode node = new EolNode(this.token);
        this.appendNode(node);
    }

    protected void parseDelimiter() {
        this.rootNode.appendNode(OtherNode.of(this.token));
    }

    @Deprecated(forRemoval=true)
    protected boolean containsOnlyWhitespaces(SqlNode node) {
        for (SqlNode child : node.getChildren()) {
            if (child instanceof WhitespaceNode) continue;
            return false;
        }
        return true;
    }

    protected void parseWhitespace() {
        this.appendNode(WhitespaceNode.of(this.token));
    }

    protected void removeNodesTo(Class<? extends SqlNode> clazz) {
        SqlNode node;
        Iterator<AppendableSqlNode> it = this.nodeStack.iterator();
        while (it.hasNext() && !clazz.isInstance(node = (SqlNode)it.next())) {
            it.remove();
        }
    }

    protected boolean isInSelectStatementNode() {
        for (SqlNode sqlNode : this.nodeStack) {
            if (sqlNode instanceof ParensNode) {
                return false;
            }
            if (!(sqlNode instanceof SelectStatementNode)) continue;
            return true;
        }
        return false;
    }

    protected boolean isInWhereClauseAwareNode() {
        for (SqlNode sqlNode : this.nodeStack) {
            if (sqlNode instanceof ParensNode) {
                return false;
            }
            if (!(sqlNode instanceof WhereClauseAwareNode)) continue;
            return true;
        }
        return false;
    }

    protected boolean isInUpdateStatementNode() {
        for (SqlNode sqlNode : this.nodeStack) {
            if (sqlNode instanceof ParensNode) {
                return false;
            }
            if (!(sqlNode instanceof UpdateStatementNode)) continue;
            return true;
        }
        return false;
    }

    protected boolean isInIfBlockNode() {
        for (SqlNode sqlNode : this.nodeStack) {
            if (sqlNode instanceof ParensNode) {
                return false;
            }
            if (!(sqlNode instanceof IfBlockNode)) continue;
            return true;
        }
        return false;
    }

    protected boolean isInForBlockNode() {
        for (SqlNode sqlNode : this.nodeStack) {
            if (sqlNode instanceof ParensNode) {
                return false;
            }
            if (!(sqlNode instanceof ForBlockNode)) continue;
            return true;
        }
        return false;
    }

    protected boolean isInParensNode() {
        for (SqlNode sqlNode : this.nodeStack) {
            if (!(sqlNode instanceof ParensNode)) continue;
            return true;
        }
        return false;
    }

    protected boolean isInBlockNode() {
        for (SqlNode sqlNode : this.nodeStack) {
            if (sqlNode instanceof ParensNode) {
                return false;
            }
            if (!(sqlNode instanceof BlockNode)) continue;
            return true;
        }
        return false;
    }

    protected boolean isAfterValueNode() {
        return this.peek() instanceof ValueNode;
    }

    protected boolean isAfterExpandNode() {
        return this.peek() instanceof ExpandNode;
    }

    @Deprecated(forRemoval=true)
    protected boolean isAfterOrderByClauseNode() {
        return this.peek() instanceof OrderByClauseNode;
    }

    protected InNode findInNode() {
        Object node = this.peek();
        List<SqlNode> children = node.getChildren();
        ListIterator<SqlNode> iterator = children.listIterator(children.size());
        while (iterator.hasPrevious()) {
            SqlNode child = iterator.previous();
            if (child instanceof WhitespaceNode || child instanceof EolNode || child instanceof CommentNode) continue;
            if (child instanceof InNode) {
                InNode inNode = (InNode)child;
                return inNode;
            }
            return null;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void appendNode(SqlNode node) {
        if (this.isAfterValueNode()) {
            ValueNode valueNode = (ValueNode)this.pop();
            if (node instanceof WordNode) {
                WordNode wordNode = (WordNode)node;
                String word = wordNode.getWord();
                Matcher matcher = LITERAL_PATTERN.matcher(word);
                if (!matcher.lookingAt()) throw new JdbcException((MessageResource)Message.DOMA2142, this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition(), valueNode.getText(), word);
                valueNode.setWordNode(wordNode);
                return;
            } else {
                if (!(node instanceof ParensNode)) throw new JdbcException((MessageResource)Message.DOMA2110, this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition(), valueNode.getText());
                ParensNode parensNode = (ParensNode)node;
                parensNode.setAttachedWithValue(true);
                valueNode.setParensNode(parensNode);
            }
            return;
        } else {
            if (this.isAfterExpandNode()) {
                ExpandNode expandNode = (ExpandNode)this.pop();
                if (!(node instanceof OtherNode)) throw new JdbcException((MessageResource)Message.DOMA2143, this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition(), expandNode.getText());
                OtherNode otherNode = (OtherNode)node;
                if (otherNode.getOther().equals("*")) return;
                throw new JdbcException((MessageResource)Message.DOMA2143, this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition(), expandNode.getText());
            }
            this.peek().appendNode(node);
        }
    }

    protected void push(AppendableSqlNode node) {
        this.nodeStack.push(node);
    }

    protected <T extends AppendableSqlNode> T peek() {
        return (T)this.nodeStack.peek();
    }

    protected <T extends SqlNode> T pop() {
        return (T)this.nodeStack.pop();
    }

    protected SqlLocation getLocation() {
        return new SqlLocation(this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition());
    }

    protected void validate() {
        if (this.isAfterValueNode()) {
            ValueNode valueNode = (ValueNode)this.pop();
            throw new JdbcException((MessageResource)Message.DOMA2110, this.sql, this.tokenizer.getLineNumber(), this.tokenizer.getPosition(), valueNode.getText());
        }
        if (this.isInIfBlockNode()) {
            this.removeNodesTo(IfBlockNode.class);
            IfBlockNode ifBlockNode = (IfBlockNode)this.pop();
            SqlLocation location = ifBlockNode.getIfNode().getLocation();
            throw new JdbcException((MessageResource)Message.DOMA2133, this.sql, location.getLineNumber(), location.getPosition());
        }
        if (this.isInForBlockNode()) {
            this.removeNodesTo(ForBlockNode.class);
            ForBlockNode forBlockNode = (ForBlockNode)this.pop();
            SqlLocation location = forBlockNode.getForNode().getLocation();
            throw new JdbcException((MessageResource)Message.DOMA2134, this.sql, location.getLineNumber(), location.getPosition());
        }
    }

    protected void validateParensClosed() {
        if (this.isInParensNode()) {
            this.removeNodesTo(ParensNode.class);
            ParensNode parensNode = (ParensNode)this.pop();
            SqlLocation location = parensNode.getLocation();
            throw new JdbcException((MessageResource)Message.DOMA2135, this.sql, location.getLineNumber(), location.getPosition());
        }
    }
}

