/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.sql;

import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.internal.util.StringUtil;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SqlTokenType {
    QUOTE,
    OPENED_PARENS,
    CLOSED_PARENS,
    LINE_COMMENT,
    BLOCK_COMMENT,
    PARSER_LEVEL_BLOCK_COMMENT,
    BIND_VARIABLE_BLOCK_COMMENT{

        @Override
        public String extract(String token) {
            AssertionUtil.assertNotNull(token);
            AssertionUtil.assertTrue(token.length() >= 5, new Object[0]);
            String s = token.substring(2, token.length() - 2);
            return StringUtil.trimWhitespace(s);
        }
    }
    ,
    LITERAL_VARIABLE_BLOCK_COMMENT{

        @Override
        public String extract(String token) {
            AssertionUtil.assertNotNull(token);
            AssertionUtil.assertTrue(token.length() >= 5, new Object[0]);
            String s = token.substring(3, token.length() - 2);
            return StringUtil.trimWhitespace(s);
        }
    }
    ,
    EMBEDDED_VARIABLE_BLOCK_COMMENT{

        @Override
        public String extract(String token) {
            AssertionUtil.assertNotNull(token);
            AssertionUtil.assertTrue(token.length() >= 5, new Object[0]);
            String s = token.substring(3, token.length() - 2);
            return StringUtil.trimWhitespace(s);
        }
    }
    ,
    IF_BLOCK_COMMENT{

        @Override
        public String extract(String token) {
            AssertionUtil.assertNotNull(token);
            AssertionUtil.assertTrue(token.length() >= 7, new Object[0]);
            String s = token.substring(5, token.length() - 2);
            return StringUtil.trimWhitespace(s);
        }
    }
    ,
    ELSEIF_BLOCK_COMMENT{

        @Override
        public String extract(String token) {
            AssertionUtil.assertNotNull(token);
            AssertionUtil.assertTrue(token.length() >= 11, new Object[0]);
            String s = token.substring(9, token.length() - 2);
            return StringUtil.trimWhitespace(s);
        }
    }
    ,
    ELSE_BLOCK_COMMENT,
    FOR_BLOCK_COMMENT{

        @Override
        public String extract(String token) {
            AssertionUtil.assertNotNull(token);
            AssertionUtil.assertTrue(token.length() >= 8, new Object[0]);
            return token.substring(6, token.length() - 2);
        }
    }
    ,
    EXPAND_BLOCK_COMMENT{

        @Override
        public String extract(String token) {
            AssertionUtil.assertNotNull(token);
            AssertionUtil.assertTrue(token.length() >= 11, new Object[0]);
            return token.substring(9, token.length() - 2);
        }
    }
    ,
    POPULATE_BLOCK_COMMENT{

        @Override
        public String extract(String token) {
            AssertionUtil.assertNotNull(token);
            AssertionUtil.assertTrue(token.length() >= 13, new Object[0]);
            return token.substring(11, token.length() - 2);
        }
    }
    ,
    END_BLOCK_COMMENT,
    DELIMITER,
    SELECT_WORD,
    WHERE_WORD,
    FROM_WORD,
    GROUP_BY_WORD,
    HAVING_WORD,
    ORDER_BY_WORD,
    FOR_UPDATE_WORD,
    OPTION_WORD,
    AND_WORD,
    OR_WORD,
    UNION_WORD,
    MINUS_WORD,
    EXCEPT_WORD,
    INTERSECT_WORD,
    UPDATE_WORD,
    SET_WORD,
    WORD,
    DISTINCT_WORD,
    IN_WORD,
    OTHER,
    WHITESPACE,
    EOL,
    EOF;


    public String extract(String token) {
        return token;
    }
}

