/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.sql;

import java.nio.CharBuffer;
import org.seasar.doma.internal.expr.util.ExpressionUtil;
import org.seasar.doma.internal.jdbc.sql.SqlTokenType;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.internal.util.SqlTokenUtil;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class SqlTokenizer {
    private static final int LOOKAHEAD_BUFFER_SIZE = 10;
    private static final int NON_WORD_LOOKAHEAD_SIZE = 2;
    private final String sql;
    private final CharBuffer buf;
    private final char[] lookahead = new char[10];
    private SqlTokenType type;
    private String token;
    private int currentLineNumber;
    private int lineNumber;
    private int lineStartPosition;
    private int position;
    private int tokenStartIndex;

    public SqlTokenizer(String sql) {
        AssertionUtil.assertNotNull(sql);
        this.sql = sql;
        this.buf = CharBuffer.wrap(sql);
        this.currentLineNumber = 1;
        this.lineNumber = 1;
        this.peek();
    }

    public SqlTokenType next() {
        switch (this.type) {
            case EOF: {
                this.token = null;
                return SqlTokenType.EOF;
            }
            case EOL: {
                this.lineStartPosition = this.buf.position();
            }
        }
        SqlTokenType currentType = this.type;
        this.prepareToken();
        this.peek();
        return currentType;
    }

    private void prepareToken() {
        this.lineNumber = this.currentLineNumber;
        this.position = this.buf.position() - this.lineStartPosition;
        this.token = this.sql.substring(this.tokenStartIndex, this.buf.position());
        this.tokenStartIndex = this.buf.position();
    }

    public String getToken() {
        return this.token;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getPosition() {
        return this.position;
    }

    private void peek() {
        if (!this.buf.hasRemaining()) {
            this.type = SqlTokenType.EOF;
            return;
        }
        int offset = this.buf.position();
        char c = this.buf.get();
        boolean isWordStart = this.isWordStart(c);
        this.buf.position(offset);
        if (isWordStart) {
            int charsRead = Math.min(this.lookahead.length, this.buf.remaining());
            this.buf.get(this.lookahead, 0, charsRead);
            this.peekWord(offset, charsRead);
        } else {
            int charsRead = Math.min(2, this.buf.remaining());
            this.buf.get(this.lookahead, 0, charsRead);
            this.peekNonWord(offset, charsRead);
        }
    }

    private void peekWord(int offset, int charsRead) {
        if (this.lookahead[0] == '\'') {
            this.buf.position(offset + 1);
            this.handleQuotedString();
            return;
        }
        if (this.lookahead[0] == '+' || this.lookahead[0] == '-') {
            this.buf.position(offset + 1);
            this.handleWord();
            return;
        }
        char firstChar = (char)(this.lookahead[0] | 0x20);
        switch (firstChar) {
            case 's': {
                if (charsRead >= 6) {
                    this.buf.position(offset + 6);
                    if (this.isSelectWord()) {
                        this.type = SqlTokenType.SELECT_WORD;
                        return;
                    }
                }
                if (charsRead < 3) break;
                this.buf.position(offset + 3);
                if (!this.isSetWord()) break;
                this.type = SqlTokenType.SET_WORD;
                return;
            }
            case 'w': {
                if (charsRead < 5) break;
                this.buf.position(offset + 5);
                if (!this.isWhereWord()) break;
                this.type = SqlTokenType.WHERE_WORD;
                return;
            }
            case 'f': {
                if (charsRead >= 10) {
                    this.buf.position(offset + 10);
                    if (this.isForUpdateWord()) {
                        this.type = SqlTokenType.FOR_UPDATE_WORD;
                        return;
                    }
                }
                if (charsRead < 4) break;
                this.buf.position(offset + 4);
                if (!this.isFromWord()) break;
                this.type = SqlTokenType.FROM_WORD;
                return;
            }
            case 'o': {
                if (charsRead >= 8) {
                    this.buf.position(offset + 8);
                    if (this.isOrderByWord()) {
                        this.type = SqlTokenType.ORDER_BY_WORD;
                        return;
                    }
                    if (this.isOptionWord()) {
                        this.buf.position(this.buf.position() - 2);
                        this.type = SqlTokenType.OPTION_WORD;
                        return;
                    }
                }
                if (charsRead < 2) break;
                this.buf.position(offset + 2);
                if (!this.isOrWord()) break;
                this.type = SqlTokenType.OR_WORD;
                return;
            }
            case 'u': {
                if (charsRead >= 6) {
                    this.buf.position(offset + 6);
                    if (this.isUpdateWord()) {
                        this.type = SqlTokenType.UPDATE_WORD;
                        return;
                    }
                }
                if (charsRead < 5) break;
                this.buf.position(offset + 5);
                if (!this.isUnionWord()) break;
                this.type = SqlTokenType.UNION_WORD;
                return;
            }
            case 'i': {
                if (charsRead >= 9) {
                    this.buf.position(offset + 9);
                    if (this.isIntersectWord()) {
                        this.type = SqlTokenType.INTERSECT_WORD;
                        return;
                    }
                }
                if (charsRead < 2) break;
                this.buf.position(offset + 2);
                if (!this.isInWord()) break;
                this.type = SqlTokenType.IN_WORD;
                return;
            }
            case 'a': {
                if (charsRead < 3) break;
                this.buf.position(offset + 3);
                if (!this.isAndWord()) break;
                this.type = SqlTokenType.AND_WORD;
                return;
            }
            case 'g': {
                if (charsRead < 8) break;
                this.buf.position(offset + 8);
                if (!this.isGroupByWord()) break;
                this.type = SqlTokenType.GROUP_BY_WORD;
                return;
            }
            case 'h': {
                if (charsRead < 6) break;
                this.buf.position(offset + 6);
                if (!this.isHavingWord()) break;
                this.type = SqlTokenType.HAVING_WORD;
                return;
            }
            case 'd': {
                if (charsRead < 8) break;
                this.buf.position(offset + 8);
                if (!this.isDistinctWord()) break;
                this.type = SqlTokenType.DISTINCT_WORD;
                return;
            }
            case 'e': {
                if (charsRead < 6) break;
                this.buf.position(offset + 6);
                if (!this.isExceptWord()) break;
                this.type = SqlTokenType.EXCEPT_WORD;
                return;
            }
            case 'm': {
                if (charsRead < 5) break;
                this.buf.position(offset + 5);
                if (!this.isMinusWord()) break;
                this.type = SqlTokenType.MINUS_WORD;
                return;
            }
        }
        this.buf.position(offset + 1);
        this.handleWord();
    }

    private void peekNonWord(int offset, int charsRead) {
        char c1 = this.lookahead[0];
        if (charsRead >= 2) {
            char c2 = this.lookahead[1];
            switch (c1) {
                case '/': {
                    if (c2 != '*') break;
                    this.buf.position(offset + 2);
                    this.handleBlockComment();
                    return;
                }
                case '-': {
                    if (c2 != '-') break;
                    this.buf.position(offset + 2);
                    this.handleLineComment();
                    return;
                }
                case '\r': {
                    if (c2 != '\n') break;
                    this.buf.position(offset + 2);
                    this.type = SqlTokenType.EOL;
                    ++this.currentLineNumber;
                    return;
                }
            }
        }
        this.buf.position(offset + 1);
        switch (c1) {
            case '\t': 
            case '\u000b': 
            case '\f': 
            case '\u001c': 
            case '\u001d': 
            case '\u001e': 
            case '\u001f': 
            case ' ': {
                this.type = SqlTokenType.WHITESPACE;
                return;
            }
            case '(': {
                this.type = SqlTokenType.OPENED_PARENS;
                return;
            }
            case ')': {
                this.type = SqlTokenType.CLOSED_PARENS;
                return;
            }
            case ';': {
                this.type = SqlTokenType.DELIMITER;
                return;
            }
            case '\n': 
            case '\r': {
                this.type = SqlTokenType.EOL;
                ++this.currentLineNumber;
                return;
            }
        }
        if (this.isWhitespace(c1)) {
            this.type = SqlTokenType.WHITESPACE;
            return;
        }
        this.type = SqlTokenType.OTHER;
    }

    private boolean isForUpdateWord() {
        return (this.lookahead[0] | 0x20) == 102 && (this.lookahead[1] | 0x20) == 111 && (this.lookahead[2] | 0x20) == 114 && this.isWhitespace(this.lookahead[3]) && (this.lookahead[4] | 0x20) == 117 && (this.lookahead[5] | 0x20) == 112 && (this.lookahead[6] | 0x20) == 100 && (this.lookahead[7] | 0x20) == 97 && (this.lookahead[8] | 0x20) == 116 && (this.lookahead[9] | 0x20) == 101 && this.isWordTerminated();
    }

    private boolean isIntersectWord() {
        return (this.lookahead[0] | 0x20) == 105 && (this.lookahead[1] | 0x20) == 110 && (this.lookahead[2] | 0x20) == 116 && (this.lookahead[3] | 0x20) == 101 && (this.lookahead[4] | 0x20) == 114 && (this.lookahead[5] | 0x20) == 115 && (this.lookahead[6] | 0x20) == 101 && (this.lookahead[7] | 0x20) == 99 && (this.lookahead[8] | 0x20) == 116 && this.isWordTerminated();
    }

    private boolean isGroupByWord() {
        return (this.lookahead[0] | 0x20) == 103 && (this.lookahead[1] | 0x20) == 114 && (this.lookahead[2] | 0x20) == 111 && (this.lookahead[3] | 0x20) == 117 && (this.lookahead[4] | 0x20) == 112 && this.isWhitespace(this.lookahead[5]) && (this.lookahead[6] | 0x20) == 98 && (this.lookahead[7] | 0x20) == 121 && this.isWordTerminated();
    }

    private boolean isOrderByWord() {
        return (this.lookahead[0] | 0x20) == 111 && (this.lookahead[1] | 0x20) == 114 && (this.lookahead[2] | 0x20) == 100 && (this.lookahead[3] | 0x20) == 101 && (this.lookahead[4] | 0x20) == 114 && this.isWhitespace(this.lookahead[5]) && (this.lookahead[6] | 0x20) == 98 && (this.lookahead[7] | 0x20) == 121 && this.isWordTerminated();
    }

    private boolean isOptionWord() {
        return (this.lookahead[0] | 0x20) == 111 && (this.lookahead[1] | 0x20) == 112 && (this.lookahead[2] | 0x20) == 116 && (this.lookahead[3] | 0x20) == 105 && (this.lookahead[4] | 0x20) == 111 && (this.lookahead[5] | 0x20) == 110 && this.isWhitespace(this.lookahead[6]) && this.lookahead[7] == '(';
    }

    private boolean isDistinctWord() {
        return (this.lookahead[0] | 0x20) == 100 && (this.lookahead[1] | 0x20) == 105 && (this.lookahead[2] | 0x20) == 115 && (this.lookahead[3] | 0x20) == 116 && (this.lookahead[4] | 0x20) == 105 && (this.lookahead[5] | 0x20) == 110 && (this.lookahead[6] | 0x20) == 99 && (this.lookahead[7] | 0x20) == 116 && this.isWordTerminated();
    }

    private boolean isSelectWord() {
        return (this.lookahead[0] | 0x20) == 115 && (this.lookahead[1] | 0x20) == 101 && (this.lookahead[2] | 0x20) == 108 && (this.lookahead[3] | 0x20) == 101 && (this.lookahead[4] | 0x20) == 99 && (this.lookahead[5] | 0x20) == 116 && this.isWordTerminated();
    }

    private boolean isHavingWord() {
        return (this.lookahead[0] | 0x20) == 104 && (this.lookahead[1] | 0x20) == 97 && (this.lookahead[2] | 0x20) == 118 && (this.lookahead[3] | 0x20) == 105 && (this.lookahead[4] | 0x20) == 110 && (this.lookahead[5] | 0x20) == 103 && this.isWordTerminated();
    }

    private boolean isExceptWord() {
        return (this.lookahead[0] | 0x20) == 101 && (this.lookahead[1] | 0x20) == 120 && (this.lookahead[2] | 0x20) == 99 && (this.lookahead[3] | 0x20) == 101 && (this.lookahead[4] | 0x20) == 112 && (this.lookahead[5] | 0x20) == 116 && this.isWordTerminated();
    }

    private boolean isUpdateWord() {
        return (this.lookahead[0] | 0x20) == 117 && (this.lookahead[1] | 0x20) == 112 && (this.lookahead[2] | 0x20) == 100 && (this.lookahead[3] | 0x20) == 97 && (this.lookahead[4] | 0x20) == 116 && (this.lookahead[5] | 0x20) == 101 && this.isWordTerminated();
    }

    private boolean isWhereWord() {
        return (this.lookahead[0] | 0x20) == 119 && (this.lookahead[1] | 0x20) == 104 && (this.lookahead[2] | 0x20) == 101 && (this.lookahead[3] | 0x20) == 114 && (this.lookahead[4] | 0x20) == 101 && this.isWordTerminated();
    }

    private boolean isUnionWord() {
        return (this.lookahead[0] | 0x20) == 117 && (this.lookahead[1] | 0x20) == 110 && (this.lookahead[2] | 0x20) == 105 && (this.lookahead[3] | 0x20) == 111 && (this.lookahead[4] | 0x20) == 110 && this.isWordTerminated();
    }

    private boolean isMinusWord() {
        return (this.lookahead[0] | 0x20) == 109 && (this.lookahead[1] | 0x20) == 105 && (this.lookahead[2] | 0x20) == 110 && (this.lookahead[3] | 0x20) == 117 && (this.lookahead[4] | 0x20) == 115 && this.isWordTerminated();
    }

    private boolean isFromWord() {
        return (this.lookahead[0] | 0x20) == 102 && (this.lookahead[1] | 0x20) == 114 && (this.lookahead[2] | 0x20) == 111 && (this.lookahead[3] | 0x20) == 109 && this.isWordTerminated();
    }

    private boolean isAndWord() {
        return (this.lookahead[0] | 0x20) == 97 && (this.lookahead[1] | 0x20) == 110 && (this.lookahead[2] | 0x20) == 100 && this.isWordTerminated();
    }

    private boolean isSetWord() {
        return (this.lookahead[0] | 0x20) == 115 && (this.lookahead[1] | 0x20) == 101 && (this.lookahead[2] | 0x20) == 116 && this.isWordTerminated();
    }

    private boolean isOrWord() {
        return (this.lookahead[0] | 0x20) == 111 && (this.lookahead[1] | 0x20) == 114 && this.isWordTerminated();
    }

    private boolean isInWord() {
        return (this.lookahead[0] | 0x20) == 105 && (this.lookahead[1] | 0x20) == 110 && this.isWordTerminated();
    }

    private void handleBlockComment() {
        this.type = SqlTokenType.BLOCK_COMMENT;
        if (this.buf.hasRemaining()) {
            char c1 = this.buf.get();
            if (ExpressionUtil.isExpressionIdentifierStart(c1)) {
                this.type = SqlTokenType.BIND_VARIABLE_BLOCK_COMMENT;
            } else if (c1 == '^') {
                this.type = SqlTokenType.LITERAL_VARIABLE_BLOCK_COMMENT;
            } else if (c1 == '#') {
                this.type = SqlTokenType.EMBEDDED_VARIABLE_BLOCK_COMMENT;
            } else if (c1 == '%') {
                this.parsePercentageDirective();
            } else {
                this.buf.position(this.buf.position() - 1);
            }
        }
        this.consumeBlockCommentContent();
    }

    private void parsePercentageDirective() {
        if (!this.buf.hasRemaining()) {
            this.throwInvalidPercentageDirectiveException();
        }
        int charsRead = Math.min(8, this.buf.remaining());
        int offset = this.buf.position();
        this.buf.get(this.lookahead, 0, charsRead);
        switch (this.lookahead[0]) {
            case '!': {
                this.buf.position(offset + 1);
                this.type = SqlTokenType.PARSER_LEVEL_BLOCK_COMMENT;
                return;
            }
            case 'i': {
                if (charsRead < 2) break;
                this.buf.position(offset + 2);
                if (!this.isIfWord()) break;
                this.type = SqlTokenType.IF_BLOCK_COMMENT;
                return;
            }
            case 'f': {
                if (charsRead < 3) break;
                this.buf.position(offset + 3);
                if (!this.isForWord()) break;
                this.type = SqlTokenType.FOR_BLOCK_COMMENT;
                return;
            }
            case 'p': {
                if (charsRead != 8) break;
                this.buf.position(offset + 8);
                if (!this.isPopulateWord()) break;
                this.type = SqlTokenType.POPULATE_BLOCK_COMMENT;
                return;
            }
            case 'e': {
                if (charsRead >= 6) {
                    this.buf.position(offset + 6);
                    if (this.isExpandWord()) {
                        this.type = SqlTokenType.EXPAND_BLOCK_COMMENT;
                        return;
                    }
                    if (this.isElseifWord()) {
                        this.type = SqlTokenType.ELSEIF_BLOCK_COMMENT;
                        return;
                    }
                }
                if (charsRead >= 4) {
                    this.buf.position(offset + 4);
                    if (this.isElseWord()) {
                        this.type = SqlTokenType.ELSE_BLOCK_COMMENT;
                        return;
                    }
                }
                if (charsRead < 3) break;
                this.buf.position(offset + 3);
                if (!this.isEndWord()) break;
                this.type = SqlTokenType.END_BLOCK_COMMENT;
                return;
            }
        }
        this.buf.position(offset);
        this.throwInvalidPercentageDirectiveException();
    }

    private void throwInvalidPercentageDirectiveException() {
        int pos = this.buf.position() - this.lineStartPosition;
        throw new JdbcException((MessageResource)Message.DOMA2119, this.sql, this.lineNumber, pos);
    }

    private boolean isPopulateWord() {
        return this.lookahead[0] == 'p' && this.lookahead[1] == 'o' && this.lookahead[2] == 'p' && this.lookahead[3] == 'u' && this.lookahead[4] == 'l' && this.lookahead[5] == 'a' && this.lookahead[6] == 't' && this.lookahead[7] == 'e' && this.isWordTerminated();
    }

    private boolean isExpandWord() {
        return this.lookahead[0] == 'e' && this.lookahead[1] == 'x' && this.lookahead[2] == 'p' && this.lookahead[3] == 'a' && this.lookahead[4] == 'n' && this.lookahead[5] == 'd' && this.isWordTerminated();
    }

    private boolean isElseifWord() {
        return this.lookahead[0] == 'e' && this.lookahead[1] == 'l' && this.lookahead[2] == 's' && this.lookahead[3] == 'e' && this.lookahead[4] == 'i' && this.lookahead[5] == 'f' && this.isWordTerminated();
    }

    private boolean isElseWord() {
        return this.lookahead[0] == 'e' && this.lookahead[1] == 'l' && this.lookahead[2] == 's' && this.lookahead[3] == 'e' && this.isWordTerminated();
    }

    private boolean isForWord() {
        return this.lookahead[0] == 'f' && this.lookahead[1] == 'o' && this.lookahead[2] == 'r' && this.isWordTerminated();
    }

    private boolean isEndWord() {
        return this.lookahead[0] == 'e' && this.lookahead[1] == 'n' && this.lookahead[2] == 'd' && this.isWordTerminated();
    }

    private boolean isIfWord() {
        return this.lookahead[0] == 'i' && this.lookahead[1] == 'f' && this.isWordTerminated();
    }

    private void consumeBlockCommentContent() {
        while (this.buf.hasRemaining()) {
            char c1 = this.buf.get();
            if (!this.buf.hasRemaining()) continue;
            this.buf.mark();
            char c2 = this.buf.get();
            if (c1 == '*' && c2 == '/') {
                return;
            }
            if (c1 == '\r' || c1 == '\n') {
                ++this.currentLineNumber;
            }
            this.buf.reset();
        }
        int pos = this.buf.position() - this.lineStartPosition;
        throw new JdbcException((MessageResource)Message.DOMA2102, this.sql, this.lineNumber, pos);
    }

    private void handleLineComment() {
        this.type = SqlTokenType.LINE_COMMENT;
        while (this.buf.hasRemaining()) {
            this.buf.mark();
            char c1 = this.buf.get();
            if (c1 != '\r' && c1 != '\n') continue;
            this.buf.reset();
            return;
        }
    }

    private void handleQuotedString() {
        this.type = SqlTokenType.QUOTE;
        if (!this.consumeQuotedContent()) {
            this.throwUnterminatedQuoteException();
        }
    }

    private boolean consumeQuotedContent() {
        while (this.buf.hasRemaining()) {
            char c1 = this.buf.get();
            if (c1 != '\'') continue;
            if (this.buf.hasRemaining()) {
                this.buf.mark();
                char c2 = this.buf.get();
                if (c2 == '\'') continue;
                this.buf.reset();
                return true;
            }
            return true;
        }
        return false;
    }

    private void handleWord() {
        this.type = SqlTokenType.WORD;
        while (this.buf.hasRemaining()) {
            this.buf.mark();
            char c2 = this.buf.get();
            if (c2 == '\'') {
                if (!this.consumeQuotedContent()) {
                    this.throwUnterminatedQuoteException();
                }
                return;
            }
            if (this.isWordPart(c2)) continue;
            this.buf.reset();
            return;
        }
    }

    private void throwUnterminatedQuoteException() {
        int pos = this.buf.position() - this.lineStartPosition;
        throw new JdbcException((MessageResource)Message.DOMA2101, this.sql, this.lineNumber, pos);
    }

    private boolean isWordStart(char c) {
        if (c == '+' || c == '-') {
            this.buf.mark();
            if (this.buf.hasRemaining()) {
                char c2 = this.buf.get();
                this.buf.reset();
                if (Character.isDigit(c2)) {
                    return true;
                }
            }
        }
        return this.isWordPart(c);
    }

    private boolean isWordTerminated() {
        this.buf.mark();
        if (this.buf.hasRemaining()) {
            char c = this.buf.get();
            this.buf.reset();
            return !this.isWordPart(c);
        }
        return true;
    }

    private boolean isWordPart(char c) {
        return SqlTokenUtil.isWordPart(c);
    }

    private boolean isWhitespace(char c) {
        return SqlTokenUtil.isWhitespace(c);
    }
}

