/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.sql.node;

import org.seasar.doma.internal.jdbc.sql.node.AbstractSqlNode;
import org.seasar.doma.internal.jdbc.sql.node.InNode;
import org.seasar.doma.internal.jdbc.sql.node.ParensNode;
import org.seasar.doma.internal.jdbc.sql.node.SqlLocation;
import org.seasar.doma.internal.jdbc.sql.node.WordNode;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.JdbcUnsupportedOperationException;
import org.seasar.doma.jdbc.SqlNode;

public abstract class ValueNode
extends AbstractSqlNode {
    protected final SqlLocation location;
    protected final String variableName;
    protected final String text;
    protected InNode inNode;
    protected WordNode wordNode;
    protected ParensNode parensNode;

    public ValueNode(SqlLocation location, String variableName, String text) {
        AssertionUtil.assertNotNull((Object)location, (Object)variableName, (Object)text);
        this.location = location;
        this.variableName = variableName;
        this.text = text;
    }

    public SqlLocation getLocation() {
        return this.location;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public void appendNode(SqlNode child) {
        throw new JdbcUnsupportedOperationException(this.getClass().getName(), "addNode");
    }

    public InNode getInNode() {
        return this.inNode;
    }

    public void setInNode(InNode inNode) {
        this.inNode = inNode;
    }

    public WordNode getWordNode() {
        return this.wordNode;
    }

    public void setWordNode(WordNode wordNode) {
        this.wordNode = wordNode;
    }

    public ParensNode getParensNode() {
        return this.parensNode;
    }

    public void setParensNode(ParensNode parensNode) {
        this.parensNode = parensNode;
    }

    public boolean isWordNodeIgnored() {
        return this.wordNode != null;
    }

    public boolean isParensNodeIgnored() {
        return this.parensNode != null;
    }
}

