/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.sql.node;

import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.jdbc.sql.node.AbstractSqlNode;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.JdbcUnsupportedOperationException;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.jdbc.SqlNodeVisitor;

public class WordNode
extends AbstractSqlNode {
    protected final String word;
    protected final boolean reserved;

    public WordNode(String word) {
        this(word, false);
    }

    public WordNode(String word, boolean reserved) {
        AssertionUtil.assertNotNull(word);
        this.word = word;
        this.reserved = reserved;
    }

    public String getWord() {
        return this.word;
    }

    public boolean isReserved() {
        return this.reserved;
    }

    @Override
    public void appendNode(SqlNode child) {
        throw new JdbcUnsupportedOperationException(this.getClass().getName(), "addNode");
    }

    @Override
    public <R, P> R accept(SqlNodeVisitor<R, P> visitor, P p) {
        if (visitor == null) {
            throw new DomaNullPointerException("visitor");
        }
        return visitor.visitWordNode(this, p);
    }
}

