/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public class PaddingIterator<E>
implements Iterator<E> {
    private final Iterator<E> iterator;
    private E lastElement;
    private int paddingSize;

    public PaddingIterator(Iterator<E> iterator, int paddingSize) {
        Objects.requireNonNull(iterator);
        if (paddingSize < 0) {
            throw new IllegalArgumentException("paddingSize must be greater than or equal to 0");
        }
        this.iterator = iterator;
        this.lastElement = null;
        this.paddingSize = paddingSize;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext() || this.paddingSize > 0;
    }

    @Override
    public E next() {
        if (this.iterator.hasNext()) {
            E element = this.iterator.next();
            this.lastElement = element;
            return element;
        }
        if (this.paddingSize > 0) {
            --this.paddingSize;
            return this.lastElement;
        }
        throw new NoSuchElementException();
    }
}

