/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.util;

public final class SqlTokenUtil {
    private static final int ASCII_SIZE = 128;
    private static final byte TYPE_WHITESPACE = 1;
    private static final byte TYPE_DELIMITER = 2;
    private static final byte[] CHAR_TYPES = new byte[128];

    private SqlTokenUtil() {
    }

    public static boolean isWordPart(char c) {
        if (c < '\u0080') {
            return (CHAR_TYPES[c] & 3) == 0;
        }
        return !Character.isWhitespace(c);
    }

    public static boolean isWhitespace(char c) {
        if (c < '\u0080') {
            return (CHAR_TYPES[c] & 1) != 0;
        }
        return Character.isWhitespace(c);
    }

    private static boolean isWhitespaceChar(char c) {
        switch (c) {
            case '\t': 
            case '\u000b': 
            case '\f': 
            case '\u001c': 
            case '\u001d': 
            case '\u001e': 
            case '\u001f': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    private static boolean isDelimiterChar(char c) {
        switch (c) {
            case '\n': 
            case '\r': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '/': 
            case ';': 
            case '<': 
            case '=': 
            case '>': {
                return true;
            }
        }
        return false;
    }

    static {
        for (int i = 0; i < 128; ++i) {
            char c = (char)i;
            byte type = 0;
            if (SqlTokenUtil.isWhitespaceChar(c)) {
                type = (byte)(type | 1);
            }
            if (SqlTokenUtil.isDelimiterChar(c)) {
                type = (byte)(type | 2);
            }
            SqlTokenUtil.CHAR_TYPES[i] = type;
        }
    }
}

