/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc;

import java.util.Objects;
import javax.sql.DataSource;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.SimpleConfigBuilder;
import org.seasar.doma.jdbc.SimpleConfigBuilderImpl;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.tx.LocalTransactionDataSource;
import org.seasar.doma.jdbc.tx.LocalTransactionManager;

public interface SimpleConfig
extends Config {
    public LocalTransactionDataSource getLocalTransactionDataSource();

    public LocalTransactionManager getLocalTransactionManager();

    public static SimpleConfigBuilder builder(String url) {
        Objects.requireNonNull(url);
        return SimpleConfigBuilderImpl.of(url);
    }

    public static SimpleConfigBuilder builder(String url, String user, String password) {
        Objects.requireNonNull(url);
        return SimpleConfigBuilderImpl.of(url, user, password);
    }

    public static SimpleConfigBuilder builder(DataSource dataSource, Dialect dialect) {
        Objects.requireNonNull(dataSource);
        Objects.requireNonNull(dialect);
        return SimpleConfigBuilderImpl.of(dataSource, dialect);
    }
}

