/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc;

import java.util.Objects;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.seasar.doma.jdbc.ClassHelper;
import org.seasar.doma.jdbc.CommandImplementors;
import org.seasar.doma.jdbc.Commenter;
import org.seasar.doma.jdbc.ConfigSupport;
import org.seasar.doma.jdbc.DuplicateColumnHandler;
import org.seasar.doma.jdbc.EntityListenerProvider;
import org.seasar.doma.jdbc.JdbcLogger;
import org.seasar.doma.jdbc.MapKeyNaming;
import org.seasar.doma.jdbc.Naming;
import org.seasar.doma.jdbc.QueryImplementors;
import org.seasar.doma.jdbc.RequiresNewController;
import org.seasar.doma.jdbc.ScriptFileLoader;
import org.seasar.doma.jdbc.SimpleConfig;
import org.seasar.doma.jdbc.SimpleConfigBuilder;
import org.seasar.doma.jdbc.SimpleConfigImpl;
import org.seasar.doma.jdbc.SimpleSqlBuilderSettings;
import org.seasar.doma.jdbc.SqlBuilderSettings;
import org.seasar.doma.jdbc.SqlFileRepository;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.jdbc.UnknownColumnHandler;
import org.seasar.doma.jdbc.dialect.Db2Dialect;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.dialect.H2Dialect;
import org.seasar.doma.jdbc.dialect.HsqldbDialect;
import org.seasar.doma.jdbc.dialect.MssqlDialect;
import org.seasar.doma.jdbc.dialect.MysqlDialect;
import org.seasar.doma.jdbc.dialect.OracleDialect;
import org.seasar.doma.jdbc.dialect.PostgresDialect;
import org.seasar.doma.jdbc.dialect.SqliteDialect;
import org.seasar.doma.jdbc.statistic.StatisticManager;
import org.seasar.doma.jdbc.tx.LocalTransactionDataSource;
import org.seasar.doma.jdbc.tx.LocalTransactionManager;

class SimpleConfigBuilderImpl
implements SimpleConfigBuilder {
    private static final Pattern jdbcUrlPattern = Pattern.compile("^jdbc:(tc:)?([^:]*):.*");
    private final LocalTransactionDataSource dataSource;
    private Dialect dialect;
    private BiFunction<LocalTransactionDataSource, JdbcLogger, LocalTransactionManager> transactionManagerFactory;
    private SqlFileRepository sqlFileRepository = ConfigSupport.defaultSqlFileRepository;
    private ScriptFileLoader scriptFileLoader = ConfigSupport.defaultScriptFileLoader;
    private JdbcLogger jdbcLogger = ConfigSupport.defaultJdbcLogger;
    private ClassHelper classHelper = ConfigSupport.defaultClassHelper;
    private CommandImplementors commandImplementors = ConfigSupport.defaultCommandImplementors;
    private QueryImplementors queryImplementors = ConfigSupport.defaultQueryImplementors;
    private SqlLogType exceptionSqlLogType = SqlLogType.FORMATTED;
    private UnknownColumnHandler unknownColumnHandler = ConfigSupport.defaultUnknownColumnHandler;
    private DuplicateColumnHandler duplicateColumnHandler = ConfigSupport.defaultDuplicateColumnHandler;
    private Naming naming = ConfigSupport.defaultNaming;
    private MapKeyNaming mapKeyNaming = ConfigSupport.defaultMapKeyNaming;
    private Commenter commenter = ConfigSupport.defaultCommenter;
    private EntityListenerProvider entityListenerProvider = ConfigSupport.defaultEntityListenerProvider;
    private SqlBuilderSettings sqlBuilderSettings = new SimpleSqlBuilderSettings();
    private StatisticManager statisticManager = ConfigSupport.defaultStatisticManager;
    int maxRows = 0;
    int fetchSize = 0;
    int queryTimeout = 0;
    int batchSize = 0;

    private SimpleConfigBuilderImpl(LocalTransactionDataSource dataSource, Dialect dialect, BiFunction<LocalTransactionDataSource, JdbcLogger, LocalTransactionManager> transactionManagerFactory) {
        this.dataSource = Objects.requireNonNull(dataSource);
        this.dialect = Objects.requireNonNull(dialect);
        this.transactionManagerFactory = Objects.requireNonNull(transactionManagerFactory);
    }

    @Override
    public SimpleConfigBuilderImpl dialect(Dialect dialect) {
        this.dialect = Objects.requireNonNull(dialect);
        return this;
    }

    @Override
    public SimpleConfigBuilderImpl jdbcLogger(JdbcLogger jdbcLogger) {
        this.jdbcLogger = Objects.requireNonNull(jdbcLogger);
        return this;
    }

    @Override
    public SimpleConfigBuilderImpl sqlFileRepository(SqlFileRepository sqlFileRepository) {
        this.sqlFileRepository = Objects.requireNonNull(sqlFileRepository);
        return this;
    }

    @Override
    public SimpleConfigBuilderImpl scriptFileLoader(ScriptFileLoader scriptFileLoader) {
        this.scriptFileLoader = Objects.requireNonNull(scriptFileLoader);
        return this;
    }

    @Override
    public SimpleConfigBuilderImpl classHelper(ClassHelper classHelper) {
        this.classHelper = Objects.requireNonNull(classHelper);
        return this;
    }

    @Override
    public SimpleConfigBuilderImpl commandImplementors(CommandImplementors commandImplementors) {
        this.commandImplementors = Objects.requireNonNull(commandImplementors);
        return this;
    }

    @Override
    public SimpleConfigBuilderImpl queryImplementors(QueryImplementors queryImplementors) {
        this.queryImplementors = Objects.requireNonNull(queryImplementors);
        return this;
    }

    @Override
    public SimpleConfigBuilderImpl exceptionSqlLogType(SqlLogType exceptionSqlLogType) {
        this.exceptionSqlLogType = Objects.requireNonNull(exceptionSqlLogType);
        return this;
    }

    @Override
    public SimpleConfigBuilderImpl unknownColumnHandler(UnknownColumnHandler unknownColumnHandler) {
        this.unknownColumnHandler = Objects.requireNonNull(unknownColumnHandler);
        return this;
    }

    @Override
    public SimpleConfigBuilderImpl duplicateColumnHandler(DuplicateColumnHandler duplicateColumnHandler) {
        this.duplicateColumnHandler = Objects.requireNonNull(duplicateColumnHandler);
        return this;
    }

    @Override
    public SimpleConfigBuilderImpl naming(Naming naming) {
        this.naming = Objects.requireNonNull(naming);
        return this;
    }

    @Override
    public SimpleConfigBuilderImpl mapKeyNaming(MapKeyNaming mapKeyNaming) {
        this.mapKeyNaming = Objects.requireNonNull(mapKeyNaming);
        return this;
    }

    @Override
    public SimpleConfigBuilderImpl transactionManagerFactory(BiFunction<LocalTransactionDataSource, JdbcLogger, LocalTransactionManager> transactionManagerFactory) {
        this.transactionManagerFactory = Objects.requireNonNull(transactionManagerFactory);
        return this;
    }

    @Override
    public SimpleConfigBuilderImpl commenter(Commenter commenter) {
        this.commenter = Objects.requireNonNull(commenter);
        return this;
    }

    @Override
    public SimpleConfigBuilderImpl entityListenerProvider(EntityListenerProvider entityListenerProvider) {
        this.entityListenerProvider = Objects.requireNonNull(entityListenerProvider);
        return this;
    }

    @Override
    public SimpleConfigBuilderImpl sqlBuilderSettings(SqlBuilderSettings sqlBuilderSettings) {
        this.sqlBuilderSettings = Objects.requireNonNull(sqlBuilderSettings);
        return this;
    }

    @Override
    public SimpleConfigBuilderImpl statisticManager(StatisticManager statisticManager) {
        this.statisticManager = Objects.requireNonNull(statisticManager);
        return this;
    }

    @Override
    public SimpleConfigBuilderImpl maxRows(int maxRows) {
        this.maxRows = maxRows;
        return this;
    }

    @Override
    public SimpleConfigBuilderImpl fetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    @Override
    public SimpleConfigBuilderImpl queryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
        return this;
    }

    @Override
    public SimpleConfigBuilderImpl batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Override
    public SimpleConfig build() {
        final LocalTransactionManager transactionManager = this.transactionManagerFactory.apply(this.dataSource, this.jdbcLogger);
        RequiresNewController requiresNewController = new RequiresNewController(){

            @Override
            public <R> R requiresNew(RequiresNewController.Callback<R> callback) throws Throwable {
                return (R)transactionManager.requiresNew(callback::execute);
            }
        };
        String dataSourceName = UUID.randomUUID().toString();
        return new SimpleConfigImpl(this.dataSource, dataSourceName, this.dialect, this.sqlFileRepository, this.scriptFileLoader, this.jdbcLogger, requiresNewController, this.classHelper, this.commandImplementors, this.queryImplementors, this.exceptionSqlLogType, this.unknownColumnHandler, this.duplicateColumnHandler, this.naming, this.mapKeyNaming, transactionManager, this.commenter, this.entityListenerProvider, this.sqlBuilderSettings, this.statisticManager, this.maxRows, this.fetchSize, this.queryTimeout, this.batchSize);
    }

    static SimpleConfigBuilderImpl of(String url) {
        Objects.requireNonNull(url);
        return SimpleConfigBuilderImpl.of(url, null, null);
    }

    static SimpleConfigBuilderImpl of(String url, String user, String password) {
        Objects.requireNonNull(url);
        String driver = SimpleConfigBuilderImpl.extractJdbcDriver(url);
        if (driver == null) {
            throw new IllegalArgumentException("Cannot identify the JDBC driver from the URL. url=" + url);
        }
        Dialect dialect = SimpleConfigBuilderImpl.inferDialect(driver);
        if (dialect == null) {
            throw new IllegalArgumentException("Cannot infer the Dialect from the URL. url=" + url + ", driver=" + driver);
        }
        LocalTransactionDataSource dataSource = new LocalTransactionDataSource(url, user, password);
        return SimpleConfigBuilderImpl.of(dataSource, dialect);
    }

    static SimpleConfigBuilderImpl of(DataSource dataSource, Dialect dialect) {
        LocalTransactionDataSource ltd;
        Objects.requireNonNull(dataSource);
        Objects.requireNonNull(dialect);
        LocalTransactionDataSource localTransactionDataSource = dataSource instanceof LocalTransactionDataSource ? (ltd = (LocalTransactionDataSource)dataSource) : new LocalTransactionDataSource(dataSource);
        return new SimpleConfigBuilderImpl(localTransactionDataSource, dialect, LocalTransactionManager::new);
    }

    static String extractJdbcDriver(String url) {
        Matcher matcher = jdbcUrlPattern.matcher(url);
        if (matcher.matches()) {
            return matcher.group(2).toLowerCase();
        }
        return null;
    }

    static Dialect inferDialect(String driver) {
        return switch (driver) {
            case "db2" -> new Db2Dialect();
            case "h2" -> new H2Dialect();
            case "mysql" -> new MysqlDialect(MysqlDialect.MySqlVersion.V8);
            case "oracle" -> new OracleDialect();
            case "postgresql" -> new PostgresDialect();
            case "sqlite" -> new SqliteDialect();
            case "sqlserver" -> new MssqlDialect();
            case "hsqldb" -> new HsqldbDialect();
            default -> null;
        };
    }
}

