/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc;

import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.jdbc.AbstractJdbcLogger;

public class UtilLoggingJdbcLogger
extends AbstractJdbcLogger<Level> {
    protected final Logger logger;

    public UtilLoggingJdbcLogger() {
        this(Level.INFO);
    }

    public UtilLoggingJdbcLogger(Level level) {
        this(level, Logger.getLogger(UtilLoggingJdbcLogger.class.getName()));
    }

    public UtilLoggingJdbcLogger(Level level, Logger logger) {
        super(level);
        if (logger == null) {
            throw new DomaNullPointerException("logger");
        }
        this.logger = logger;
    }

    @Override
    protected void log(Level level, String callerClassName, String callerMethodName, Throwable throwable, Supplier<String> messageSupplier) {
        this.logger.logp(level, callerClassName, callerMethodName, throwable, messageSupplier);
    }
}

